/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.waypointSearch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;

final class Engine {
    private Engine() {
    }

    static List<Marker> searchGpxWaypoints(String waypointSearchPattern) {
        ArrayList<Marker> returnList = new ArrayList<Marker>();
        if (Engine.gpxLayersExist()) {
            Iterator it = MainApplication.getLayerManager().getLayersOfType(MarkerLayer.class).iterator();
            while (it.hasNext()) {
                for (Marker marker : ((MarkerLayer)it.next()).data) {
                    if (!Pattern.matches(".*\\Q" + waypointSearchPattern.toLowerCase() + "\\E.*", marker.getText().toLowerCase())) continue;
                    returnList.add(marker);
                }
            }
        }
        return returnList;
    }

    static boolean gpxLayersExist() {
        return !MainApplication.getLayerManager().getLayersOfType(MarkerLayer.class).isEmpty();
    }
}

