/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.conflict.ConflictAddCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import reverter.DataSetCommandMerger;
import reverter.OsmServerMultiObjectReader;
import reverter.RevertRedactedChangesetException;
import reverter.corehacks.ChangesetDataSet;
import reverter.corehacks.OsmServerChangesetReader;

public class ChangesetReverter {
    public static final Collection<Long> MODERATOR_REDACTION_ACCOUNTS = Collections.unmodifiableCollection(Arrays.asList(722137L, 760215L));
    public final int changesetId;
    public final Changeset changeset;
    public final RevertType revertType;
    private final OsmDataLayer layer;
    private final DataSet ds;
    private final ChangesetDataSet cds;
    private DataSet nds;
    private final HashSet<PrimitiveId> missing = new HashSet();
    private final HashSet<HistoryOsmPrimitive> created = new HashSet();
    private final HashSet<HistoryOsmPrimitive> updated = new HashSet();
    private final HashSet<HistoryOsmPrimitive> deleted = new HashSet();

    private void addIfMissing(PrimitiveId id) {
        OsmPrimitive p = this.ds.getPrimitiveById(id);
        if (p == null || p.isIncomplete()) {
            this.missing.add(id);
        }
    }

    private void addMissingHistoryIds(Iterable<HistoryOsmPrimitive> primitives) {
        for (HistoryOsmPrimitive p : primitives) {
            this.addIfMissing(p.getPrimitiveId());
            if (p.getType() != OsmPrimitiveType.WAY) continue;
            Iterator iterator = ((HistoryWay)p).getNodes().iterator();
            while (iterator.hasNext()) {
                long nd = (Long)iterator.next();
                this.addIfMissing((PrimitiveId)new SimplePrimitiveId(nd, OsmPrimitiveType.NODE));
            }
        }
    }

    private void addMissingIds(Iterable<OsmPrimitive> primitives) {
        for (OsmPrimitive p : primitives) {
            this.addIfMissing((PrimitiveId)p);
            if (p.getType() != OsmPrimitiveType.WAY) continue;
            for (Node nd : ((Way)p).getNodes()) {
                this.addIfMissing((PrimitiveId)nd);
            }
        }
    }

    private boolean checkOsmChangeEntry(ChangesetDataSet.ChangesetDataSetEntry entry) {
        if (this.revertType == RevertType.FULL) {
            return true;
        }
        if (this.revertType == RevertType.SELECTION_WITH_UNDELETE && entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.DELETED) {
            return true;
        }
        OsmPrimitive p = this.ds.getPrimitiveById(entry.getPrimitive().getPrimitiveId());
        if (p == null) {
            return false;
        }
        return p.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangesetReverter(int changesetId, RevertType revertType, boolean newLayer, ProgressMonitor monitor) throws OsmTransferException, RevertRedactedChangesetException {
        this.changesetId = changesetId;
        if (newLayer) {
            this.ds = new DataSet();
            this.layer = new OsmDataLayer(this.ds, I18n.tr((String)"Reverted changeset", (Object[])new Object[0]) + I18n.tr((String)" [id: {0}]", (Object[])new Object[]{String.valueOf(changesetId)}), null);
        } else {
            this.layer = MainApplication.getLayerManager().getEditLayer();
            this.ds = this.layer.data;
        }
        this.revertType = revertType;
        OsmServerChangesetReader csr = new OsmServerChangesetReader();
        monitor.beginTask("", 2);
        this.changeset = csr.readChangeset(changesetId, monitor.createSubTaskMonitor(1, false));
        if (MODERATOR_REDACTION_ACCOUNTS.contains(this.changeset.getUser().getId())) {
            throw new RevertRedactedChangesetException(I18n.tr((String)"It is not allowed to revert changeset from {0}", (Object[])new Object[]{this.changeset.getUser().getName()}));
        }
        try {
            this.cds = csr.downloadChangeset(changesetId, monitor.createSubTaskMonitor(1, false));
        }
        finally {
            monitor.finishTask();
            if (newLayer) {
                GuiHelper.runInEDT(() -> MainApplication.getLayerManager().addLayer((Layer)this.layer));
            }
        }
        Iterator<ChangesetDataSet.ChangesetDataSetEntry> it = this.cds.iterator();
        while (it.hasNext()) {
            ChangesetDataSet.ChangesetDataSetEntry entry = it.next();
            if (!this.checkOsmChangeEntry(entry)) continue;
            if (entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.CREATED) {
                this.created.add(entry.getPrimitive());
                continue;
            }
            if (entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.UPDATED) {
                this.updated.add(entry.getPrimitive());
                continue;
            }
            if (entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.DELETED) {
                this.deleted.add(entry.getPrimitive());
                continue;
            }
            throw new AssertionError();
        }
    }

    public void checkMissingCreated() {
        this.addMissingHistoryIds(this.created);
    }

    public void checkMissingUpdated() {
        this.addMissingHistoryIds(this.updated);
    }

    public void checkMissingDeleted() {
        this.addMissingHistoryIds(this.deleted);
    }

    private void readObjectVersion(OsmServerMultiObjectReader rdr, PrimitiveId id, int version, ProgressMonitor progressMonitor) throws OsmTransferException {
        boolean readOK = false;
        while (!readOK && version >= 1) {
            try {
                rdr.readObject(id, version, progressMonitor.createSubTaskMonitor(1, true));
                readOK = true;
            }
            catch (OsmApiException e) {
                if (e.getResponseCode() != 403) {
                    throw e;
                }
                String message = "Version " + version + " of " + id + " is unauthorized";
                if (version > 1) {
                    message = message + ", requesting previous one";
                }
                Logging.info((String)message);
                --version;
            }
        }
        if (!readOK) {
            Logging.warn((String)("Cannot retrieve any previous version of " + id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadObjectsHistory(ProgressMonitor progressMonitor) throws OsmTransferException {
        OsmServerMultiObjectReader rdr = new OsmServerMultiObjectReader();
        progressMonitor.beginTask(I18n.tr((String)"Downloading objects history", (Object[])new Object[0]), this.updated.size() + this.deleted.size() + 1);
        try {
            for (HashSet collection : Arrays.asList(this.updated, this.deleted)) {
                for (HistoryOsmPrimitive entry : collection) {
                    PrimitiveId id = entry.getPrimitiveId();
                    this.readObjectVersion(rdr, id, this.cds.getEarliestVersion(id) - 1, progressMonitor);
                    if (!progressMonitor.isCanceled()) continue;
                    return;
                }
            }
            this.nds = rdr.parseOsm(progressMonitor.createSubTaskMonitor(1, true));
            block11: for (OsmPrimitive p : this.nds.allPrimitives()) {
                if (!p.isIncomplete()) {
                    this.addMissingIds(Collections.singleton(p));
                    continue;
                }
                if (this.ds.getPrimitiveById(p.getPrimitiveId()) != null) continue;
                switch (p.getType()) {
                    case NODE: {
                        this.ds.addPrimitive((OsmPrimitive)new Node(p.getUniqueId()));
                        continue block11;
                    }
                    case CLOSEDWAY: 
                    case WAY: {
                        this.ds.addPrimitive((OsmPrimitive)new Way(p.getUniqueId()));
                        continue block11;
                    }
                    case MULTIPOLYGON: 
                    case RELATION: {
                        this.ds.addPrimitive((OsmPrimitive)new Relation(p.getUniqueId()));
                        continue block11;
                    }
                }
                throw new AssertionError();
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public void downloadMissingPrimitives(ProgressMonitor monitor) throws OsmTransferException {
        if (!this.hasMissingObjects()) {
            return;
        }
        MultiFetchServerObjectReader rdr = MultiFetchServerObjectReader.create();
        block5: for (PrimitiveId id : this.missing) {
            switch (id.getType()) {
                case NODE: {
                    rdr.append((OsmPrimitive)new Node(id.getUniqueId()));
                    continue block5;
                }
                case CLOSEDWAY: 
                case WAY: {
                    rdr.append((OsmPrimitive)new Way(id.getUniqueId()));
                    continue block5;
                }
                case MULTIPOLYGON: 
                case RELATION: {
                    rdr.append((OsmPrimitive)new Relation(id.getUniqueId()));
                    continue block5;
                }
            }
            throw new AssertionError();
        }
        DataSet source = rdr.parseOsm(monitor);
        for (OsmPrimitive p : source.allPrimitives()) {
            if (p.isVisible() || p.isDeleted()) continue;
            p.setDeleted(true);
            p.setModified(false);
        }
        this.layer.mergeFrom(source);
        this.missing.clear();
    }

    private static Conflict<? extends OsmPrimitive> CreateConflict(OsmPrimitive p, boolean isMyDeleted) {
        switch (p.getType()) {
            case NODE: {
                return new Conflict((OsmPrimitive)((Node)p), (OsmPrimitive)new Node((Node)p), isMyDeleted);
            }
            case CLOSEDWAY: 
            case WAY: {
                return new Conflict((OsmPrimitive)((Way)p), (OsmPrimitive)new Way((Way)p), isMyDeleted);
            }
            case MULTIPOLYGON: 
            case RELATION: {
                return new Conflict((OsmPrimitive)((Relation)p), (OsmPrimitive)new Relation((Relation)p), isMyDeleted);
            }
        }
        throw new AssertionError();
    }

    private boolean hasEqualSemanticAttributes(OsmPrimitive current, HistoryOsmPrimitive history) {
        if (!current.getKeys().equals((Object)history.getTags())) {
            return false;
        }
        switch (current.getType()) {
            case NODE: {
                LatLon currentCoor = ((Node)current).getCoor();
                LatLon historyCoor = ((HistoryNode)history).getCoords();
                if (currentCoor == historyCoor || currentCoor != null && historyCoor != null && currentCoor.equals((Object)historyCoor)) {
                    return true;
                }
                if (currentCoor != null && historyCoor == null) {
                    LatLon previousCoor = ((Node)this.nds.getPrimitiveById(history.getPrimitiveId())).getCoor();
                    return previousCoor != null && previousCoor.equals((Object)currentCoor);
                }
                return false;
            }
            case CLOSEDWAY: 
            case WAY: {
                List currentNodes = ((Way)current).getNodes();
                List historyNodes = ((HistoryWay)history).getNodes();
                if (currentNodes.size() != historyNodes.size()) {
                    return false;
                }
                for (int i = 0; i < currentNodes.size(); ++i) {
                    if (((Node)currentNodes.get(i)).getId() == ((Long)historyNodes.get(i)).longValue()) continue;
                    return false;
                }
                return true;
            }
            case MULTIPOLYGON: 
            case RELATION: {
                List currentMembers = ((Relation)current).getMembers();
                List historyMembers = ((HistoryRelation)history).getMembers();
                if (currentMembers.size() != historyMembers.size()) {
                    return false;
                }
                for (int i = 0; i < currentMembers.size(); ++i) {
                    RelationMember currentMember = (RelationMember)currentMembers.get(i);
                    RelationMemberData historyMember = (RelationMemberData)historyMembers.get(i);
                    if (!currentMember.getRole().equals(historyMember.getRole())) {
                        return false;
                    }
                    if (currentMember.getMember().getPrimitiveId().equals(new SimplePrimitiveId(historyMember.getMemberId(), historyMember.getMemberType()))) continue;
                    return false;
                }
                return true;
            }
        }
        throw new AssertionError();
    }

    public List<Command> getCommands() {
        List list;
        List list2;
        OsmPrimitive p;
        if (this.nds == null) {
            return null;
        }
        DataSetCommandMerger merger = new DataSetCommandMerger(this.nds, this.ds);
        List<Command> cmds = merger.getCommandList();
        HashSet<OsmPrimitive> toDelete = new HashSet<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : this.nds.allPrimitives()) {
            OsmPrimitive dp;
            if (osmPrimitive.isVisible() || (dp = this.ds.getPrimitiveById((PrimitiveId)osmPrimitive)) == null) continue;
            toDelete.add(dp);
        }
        for (HistoryOsmPrimitive historyOsmPrimitive : this.created) {
            p = this.ds.getPrimitiveById(historyOsmPrimitive.getPrimitiveId());
            if (p == null) continue;
            toDelete.add(p);
        }
        HashSet<OsmPrimitive> conflicted = new HashSet<OsmPrimitive>();
        for (Conflict conflict : merger.getConflicts()) {
            cmds.add((Command)new ConflictAddCommand(this.layer.data, conflict));
        }
        Iterator<ChangesetDataSet.ChangesetDataSetEntry> iterator = this.cds.iterator();
        while (iterator.hasNext()) {
            ChangesetDataSet.ChangesetDataSetEntry entry = iterator.next();
            if (!this.checkOsmChangeEntry(entry)) continue;
            HistoryOsmPrimitive hp = entry.getPrimitive();
            OsmPrimitive dp = this.ds.getPrimitiveById(hp.getPrimitiveId());
            if (dp == null || dp.isIncomplete()) {
                throw new IllegalStateException(I18n.tr((String)"Missing merge target for {0} with id {1}", (Object[])new Object[]{hp.getType(), hp.getId()}));
            }
            if (hp.getVersion() == (long)dp.getVersion() || !hp.isVisible() && !dp.isVisible() || this.hasEqualSemanticAttributes(dp, hp) || toDelete.contains(dp) && dp.isDeleted()) continue;
            cmds.add((Command)new ConflictAddCommand(this.layer.data, ChangesetReverter.CreateConflict(dp, entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.CREATED)));
            conflicted.add(dp);
        }
        Iterator iterator2 = toDelete.iterator();
        block4: while (iterator2.hasNext()) {
            p = (OsmPrimitive)iterator2.next();
            if (p.isDeleted()) {
                iterator2.remove();
                continue;
            }
            for (OsmPrimitive referrer : p.getReferrers()) {
                if (toDelete.contains(referrer) || this.nds.getPrimitiveById((PrimitiveId)referrer) != null) continue;
                if (!conflicted.contains(p)) {
                    cmds.add((Command)new ConflictAddCommand(this.layer.data, ChangesetReverter.CreateConflict(p, true)));
                    conflicted.add(p);
                }
                iterator2.remove();
                continue block4;
            }
        }
        List list3 = OsmPrimitive.getFilteredList(toDelete, Relation.class);
        if (!list3.isEmpty()) {
            cmds.add((Command)new DeleteCommand((Collection)list3));
        }
        if (!(list2 = OsmPrimitive.getFilteredList(toDelete, Way.class)).isEmpty()) {
            cmds.add((Command)new DeleteCommand((Collection)list2));
        }
        if (!(list = OsmPrimitive.getFilteredList(toDelete, Node.class)).isEmpty()) {
            cmds.add((Command)new DeleteCommand((Collection)list));
        }
        return cmds;
    }

    public boolean hasMissingObjects() {
        return !this.missing.isEmpty();
    }

    public void fixNodesWithoutCoordinates(ProgressMonitor progressMonitor) throws OsmTransferException {
        for (Node n : this.nds.getNodes()) {
            PrimitiveId id;
            OsmPrimitive p;
            if (n.isDeleted() || n.getCoor() != null || !((p = this.ds.getPrimitiveById(id = n.getPrimitiveId())) instanceof Node) || p.getVersion() <= 1) continue;
            LatLon coor = ((Node)p).getCoor();
            if (coor == null) {
                OsmServerMultiObjectReader rdr = new OsmServerMultiObjectReader();
                this.readObjectVersion(rdr, id, p.getVersion() - 1, progressMonitor);
                Collection result = rdr.parseOsm(progressMonitor.createSubTaskMonitor(1, true)).allPrimitives();
                if (!result.isEmpty()) {
                    coor = ((Node)result.iterator().next()).getCoor();
                }
            }
            if (coor == null) continue;
            n.setCoor(coor);
        }
    }

    public static enum RevertType {
        FULL,
        SELECTION,
        SELECTION_WITH_UNDELETE;

    }
}

