/*
 * Decompiled with CFR 0.152.
 */
package indoor_sweepline;

import indoor_sweepline.CorridorGeography;
import indoor_sweepline.CorridorPart;
import indoor_sweepline.ModelGeography;
import java.util.Vector;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

public class BeamGeography {
    private Vector<CorridorPart> parts;
    private Vector<CorridorGeography> partsGeography = new Vector();
    private ModelGeography target;
    private DataSet dataSet;
    private Vector<Node> nodes = new Vector();

    public BeamGeography(DataSet dataSet, ModelGeography target) {
        this.dataSet = dataSet;
        this.target = target;
    }

    public void appendNodes(int from, int to, String level) {
        if (from <= to) {
            for (int i = from; i < to; ++i) {
                this.target.appendNode(this.nodes.elementAt(i));
                CorridorPart part = this.parts.elementAt(i);
                this.partsGeography.elementAt(i).appendNodes(part.getType(), part.getSide(), level, this.nodes.elementAt(i).getCoor(), this.nodes.elementAt(i + 1).getCoor(), this.target);
            }
            this.target.appendNode(this.nodes.elementAt(to));
        } else {
            for (int i = from; i > to; --i) {
                this.target.appendNode(this.nodes.elementAt(i));
                CorridorPart part = this.parts.elementAt(i - 1);
                this.partsGeography.elementAt(i - 1).appendNodes(part.getType(), part.getSide(), level, this.nodes.elementAt(i).getCoor(), this.nodes.elementAt(i - 1).getCoor(), this.target);
            }
            this.target.appendNode(this.nodes.elementAt(to));
        }
    }

    public void adjustNodes(LatLon pivot, Vector<CorridorPart> parts, double beamOffset) {
        double offset = -beamOffset;
        this.parts = parts;
        this.adjustNode(0, new LatLon(BeamGeography.addMetersToLat(pivot, offset), pivot.lon()));
        for (int i = 0; i < parts.size(); ++i) {
            this.adjustPartGeography(i);
            this.adjustNode(i + 1, new LatLon(BeamGeography.addMetersToLat(pivot, offset += parts.elementAt((int)i).width), pivot.lon()));
        }
    }

    private void adjustNode(int i, LatLon coor) {
        Node node;
        if (this.nodes.size() <= i) {
            this.nodes.setSize(i + 1);
        }
        if ((node = this.nodes.elementAt(i)) == null) {
            node = new Node(coor);
            this.dataSet.addPrimitive((OsmPrimitive)node);
            this.nodes.setElementAt(node, i);
        } else {
            node.setCoor(coor);
        }
    }

    private void adjustPartGeography(int i) {
        CorridorGeography partGeography;
        if (this.partsGeography.size() <= i) {
            this.partsGeography.setSize(i + 1);
        }
        if ((partGeography = this.partsGeography.elementAt(i)) == null) {
            partGeography = new CorridorGeography(this.dataSet);
            this.partsGeography.setElementAt(partGeography, i);
        }
    }

    public LatLon coorAt(int i) {
        return this.nodes.elementAt(i).getCoor();
    }

    private static double addMetersToLat(LatLon latLon, double south) {
        return latLon.lat() - south * 9.0E-6;
    }
}

