/*
 * Decompiled with CFR 0.152.
 */
package seachart;

import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import s57.S57map;
import seachart.ChartImage;

public class SeachartAction
extends JosmAction
implements MainLayerManager.ActiveLayerChangeListener,
LayerManager.LayerChangeListener {
    private static String title = "SeaChart";
    private boolean isOpen = false;
    public static ChartImage rendering;
    public static S57map map;
    public DataSet data = null;
    private final DataSetListener dataSetListener = new DataSetListener(){

        public void dataChanged(DataChangedEvent e) {
            SeachartAction.this.makeChart();
        }

        public void nodeMoved(NodeMovedEvent e) {
            SeachartAction.this.makeChart();
        }

        public void otherDatasetChange(AbstractDatasetChangedEvent e) {
            SeachartAction.this.makeChart();
        }

        public void primitivesAdded(PrimitivesAddedEvent e) {
            SeachartAction.this.makeChart();
        }

        public void primitivesRemoved(PrimitivesRemovedEvent e) {
            SeachartAction.this.makeChart();
        }

        public void relationMembersChanged(RelationMembersChangedEvent e) {
            SeachartAction.this.makeChart();
        }

        public void tagsChanged(TagsChangedEvent e) {
            SeachartAction.this.makeChart();
        }

        public void wayNodesChanged(WayNodesChangedEvent e) {
            SeachartAction.this.makeChart();
        }
    };

    public SeachartAction() {
        super(title, "SC", title, null, true);
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if ("SeaChart".equals(e.getRemovedLayer().getName())) {
            this.closeChartLayer();
        }
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    public void actionPerformed(ActionEvent arg0) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!SeachartAction.this.isOpen) {
                    SeachartAction.this.createChartLayer();
                }
                SeachartAction.this.isOpen = true;
            }
        });
    }

    protected void createChartLayer() {
        rendering = new ChartImage(new ImageryInfo("SeaChart"));
        rendering.setBackgroundLayer(true);
        Main.getLayerManager().addLayer((Layer)rendering);
        Main.getLayerManager().addAndFireActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        Main.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
    }

    public void closeChartLayer() {
        if (this.isOpen) {
            try {
                Main.getLayerManager().removeActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
                Main.getLayerManager().removeLayerChangeListener((LayerManager.LayerChangeListener)this);
                Main.getLayerManager().removeLayer((Layer)rendering);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        this.isOpen = false;
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        OsmDataLayer newLayer;
        OsmDataLayer oldLayer = e.getPreviousEditLayer();
        if (oldLayer != null) {
            oldLayer.data.removeDataSetListener(this.dataSetListener);
        }
        if ((newLayer = Main.getLayerManager().getEditLayer()) != null) {
            newLayer.data.addDataSetListener(this.dataSetListener);
            this.data = newLayer.data;
            this.makeChart();
        } else {
            this.data = null;
            map = null;
        }
    }

    void makeChart() {
        map = new S57map(false);
        if (this.data != null) {
            double minlat = 90.0;
            double maxlat = -90.0;
            double minlon = 180.0;
            double maxlon = -180.0;
            for (Bounds bounds : this.data.getDataSourceBounds()) {
                if (bounds.getMinLat() < minlat) {
                    minlat = bounds.getMinLat();
                }
                if (bounds.getMaxLat() > maxlat) {
                    maxlat = bounds.getMaxLat();
                }
                if (bounds.getMinLon() < minlon) {
                    minlon = bounds.getMinLon();
                }
                if (!(bounds.getMaxLon() > maxlon)) continue;
                maxlon = bounds.getMaxLon();
            }
            map.addNode(1L, maxlat, minlon);
            map.addNode(2L, minlat, minlon);
            map.addNode(3L, minlat, maxlon);
            map.addNode(4L, maxlat, maxlon);
            SeachartAction.map.bounds.minlat = Math.toRadians(minlat);
            SeachartAction.map.bounds.maxlat = Math.toRadians(maxlat);
            SeachartAction.map.bounds.minlon = Math.toRadians(minlon);
            SeachartAction.map.bounds.maxlon = Math.toRadians(maxlon);
            for (Node node : this.data.getNodes()) {
                LatLon coor = node.getCoor();
                if (coor == null) continue;
                map.addNode(node.getUniqueId(), coor.lat(), coor.lon());
                for (Map.Entry entry : node.getKeys().entrySet()) {
                    map.addTag((String)entry.getKey(), (String)entry.getValue());
                }
                map.tagsDone(node.getUniqueId());
            }
            for (Way way : this.data.getWays()) {
                if (way.getNodesCount() <= 0) continue;
                map.addEdge(way.getUniqueId());
                for (Node node : way.getNodes()) {
                    map.addToEdge(node.getUniqueId());
                }
                for (Map.Entry entry : way.getKeys().entrySet()) {
                    map.addTag((String)entry.getKey(), (String)entry.getValue());
                }
                map.tagsDone(way.getUniqueId());
            }
            for (Relation rel : this.data.getRelations()) {
                if (!rel.isMultipolygon() || rel.getMembersCount() <= 0) continue;
                map.addArea(rel.getUniqueId());
                for (RelationMember mem : rel.getMembers()) {
                    if (mem.getType() != OsmPrimitiveType.WAY) continue;
                    map.addToArea(mem.getUniqueId(), mem.getRole().equals("outer"));
                }
                for (Map.Entry entry : rel.getKeys().entrySet()) {
                    map.addTag((String)entry.getKey(), (String)entry.getValue());
                }
                map.tagsDone(rel.getUniqueId());
            }
            map.mapDone();
            if (rendering != null) {
                rendering.zoomChanged();
            }
        }
    }

    static {
        map = null;
    }
}

