/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import org.geotools.resources.i18n.Errors;
import org.opengis.util.ProgressListener;

public abstract class BaseGridCoverageProgressAdapter {
    protected int lastImageIndex;
    protected final ProgressListener monitor;
    protected final int numImages;
    protected float progressStep;
    protected float progress;

    protected BaseGridCoverageProgressAdapter(ProgressListener monitor, int numImages) {
        if (numImages <= 0) {
            throw new IllegalArgumentException(Errors.format(58, "numImages", numImages));
        }
        this.numImages = numImages;
        if (monitor == null) {
            throw new NullPointerException(Errors.format(143, "monitor"));
        }
        this.monitor = monitor;
        this.init();
    }

    protected void init() {
        this.progressStep = 1.0f / (float)this.numImages;
    }
}

