/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.color;

import java.awt.Color;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.opengis.filter.capability.FunctionName;

public class MixFunction
extends FunctionImpl {
    public static FunctionName NAME = new FunctionNameImpl("mix", FunctionNameImpl.parameter("result", Color.class), FunctionNameImpl.parameter("color1", Color.class), FunctionNameImpl.parameter("color2", Color.class), FunctionNameImpl.parameter("weight", Double.class));

    public MixFunction() {
        this.functionName = NAME;
    }

    @Override
    public Object evaluate(Object object) {
        Color color1 = (Color)this.getParameterValue(object, 0);
        Color color2 = (Color)this.getParameterValue(object, 1);
        double weight = (Double)this.getParameterValue(object, 2);
        return this.mix(color1, color2, weight);
    }

    protected Color mix(Color color1, Color color2, double weight) {
        double w = weight * 2.0 - 1.0;
        double da = color1.getAlpha() - color2.getAlpha();
        double w1 = ((w * da == -1.0 ? w : (w + da) / (1.0 + w * da)) + 1.0) / 2.0;
        double w2 = 1.0 - w1;
        int red = (int)Math.round((double)color1.getRed() * w1 + (double)color2.getRed() * w2);
        int green = (int)Math.round((double)color1.getGreen() * w1 + (double)color2.getGreen() * w2);
        int blue = (int)Math.round((double)color1.getBlue() * w1 + (double)color2.getBlue() * w2);
        int alpha = 255;
        if (color1.getAlpha() < 255 || color2.getAlpha() < 255) {
            alpha = (int)Math.round((double)color1.getAlpha() * weight + (double)color2.getAlpha() * (1.0 - weight));
        }
        return new Color(red, green, blue, alpha);
    }
}

