/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.io.output;

import java.io.IOException;
import java.io.OutputStream;

public class FastBufferedOutputStream
extends OutputStream {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected byte[] buffer;
    protected int pos;
    protected int avail;
    protected OutputStream os;

    public FastBufferedOutputStream(OutputStream os, int bufSize) {
        this.os = os;
        this.buffer = new byte[bufSize];
        this.avail = bufSize;
    }

    public FastBufferedOutputStream(OutputStream os) {
        this(os, 8192);
    }

    private void dumpBufferIfFull() throws IOException {
        if (this.avail == 0) {
            this.os.write(this.buffer, 0, this.pos);
            this.pos = 0;
            this.avail = this.buffer.length;
        }
    }

    public void write(int b) throws IOException {
        --this.avail;
        this.buffer[this.pos++] = (byte)b;
        this.dumpBufferIfFull();
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        if (length <= this.avail) {
            System.arraycopy(b, offset, this.buffer, this.pos, length);
            this.pos += length;
            this.avail -= length;
            this.dumpBufferIfFull();
            return;
        }
        System.arraycopy(b, offset, this.buffer, this.pos, this.avail);
        this.os.write(this.buffer, 0, this.pos + this.avail);
        int residual = (length -= this.avail) % this.buffer.length;
        this.os.write(b, offset += this.avail, length - residual);
        System.arraycopy(b, offset + length - residual, this.buffer, 0, residual);
        this.pos = residual;
        this.avail = this.buffer.length - residual;
    }

    public void flush() throws IOException {
        if (this.pos != 0) {
            this.os.write(this.buffer, 0, this.pos);
        }
        this.pos = 0;
        this.os.flush();
    }

    public void close() throws IOException {
        if (this.os == null) {
            return;
        }
        if (this.pos != 0) {
            this.os.write(this.buffer, 0, this.pos);
        }
        if (this.os != System.out) {
            this.os.close();
        }
        this.os = null;
        this.buffer = null;
    }
}

