/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.geojson;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.geojson.Feature;
import org.geojson.FeatureCollection;
import org.geojson.GeoJsonObject;
import org.geojson.GeometryCollection;
import org.geojson.LineString;
import org.geojson.LngLatAlt;
import org.geojson.MultiLineString;
import org.geojson.MultiPoint;
import org.geojson.MultiPolygon;
import org.geojson.Point;
import org.geojson.Polygon;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;

public class DataSetBuilder {
    public static final int MAX_LINK_LENGTH = 102400;
    private DataSet dataSet;

    public BoundedDataSet build(GeoJsonObject data) {
        this.dataSet = new DataSet();
        if (data instanceof FeatureCollection) {
            this.processFeatureCollection((FeatureCollection)data);
        } else if (data instanceof GeometryCollection) {
            this.processGeometryCollection(null, (GeometryCollection)data);
        } else if (data instanceof Feature) {
            this.processFeature((Feature)data);
        } else {
            this.processGeometry(null, data);
        }
        Bounds bounds = null;
        for (OsmPrimitive osmPrimitive : this.dataSet.allPrimitives()) {
            bounds = this.mergeBounds(bounds, osmPrimitive);
        }
        return new BoundedDataSet(this.dataSet, bounds);
    }

    private void processFeatureCollection(FeatureCollection data) {
        for (Feature feature : data) {
            this.processFeature(feature);
        }
    }

    private void processGeometryCollection(Feature feature, GeometryCollection geometryCollection) {
        for (GeoJsonObject geometry : geometryCollection) {
            this.processGeometry(feature, geometry);
        }
    }

    private void processFeature(Feature feature) {
        this.processGeometry(feature, feature.getGeometry());
    }

    private void processMultiPoint(Feature feature, MultiPoint multiPoint) {
        for (LngLatAlt point : multiPoint.getCoordinates()) {
            this.processPoint(feature, point);
        }
    }

    private void processGeometry(Feature feature, GeoJsonObject geometry) {
        if (geometry instanceof Feature) {
            this.processGeometry((Feature)geometry, ((Feature)geometry).getGeometry());
        } else if (geometry instanceof Point) {
            this.processPoint(feature, ((Point)geometry).getCoordinates());
        } else if (geometry instanceof LineString) {
            this.processLineString(feature, ((LineString)geometry).getCoordinates());
        } else if (geometry instanceof Polygon) {
            this.processPolygon(feature, ((Polygon)geometry).getCoordinates());
        } else if (geometry instanceof MultiPoint) {
            this.processMultiPoint(feature, (MultiPoint)geometry);
        } else if (geometry instanceof MultiLineString) {
            this.processMultiLineString(feature, (MultiLineString)geometry);
        } else if (geometry instanceof MultiPolygon) {
            this.processMultiPolygon(feature, (MultiPolygon)geometry);
        } else if (geometry instanceof GeometryCollection) {
            this.processGeometryCollection(feature, (GeometryCollection)geometry);
        }
    }

    private void processMultiPolygon(Feature feature, MultiPolygon geometry) {
        for (List polygon : geometry.getCoordinates()) {
            this.processPolygon(feature, polygon);
        }
    }

    private void processMultiLineString(Feature feature, MultiLineString multiLineString) {
        for (List coordinates : multiLineString.getCoordinates()) {
            this.processLineString(feature, coordinates);
        }
    }

    private void processPoint(Feature feature, LngLatAlt geometry) {
        Node node = this.createNode(geometry);
        this.fillTagsFromFeature(feature, (OsmPrimitive)node);
    }

    private void processLineString(Feature feature, List<LngLatAlt> coordinates) {
        if (coordinates.isEmpty()) {
            return;
        }
        Way way = this.createWay(coordinates);
        this.fillTagsFromFeature(feature, (OsmPrimitive)way);
    }

    private void processPolygon(Feature feature, List<List<LngLatAlt>> coordinates) {
        if (coordinates.isEmpty()) {
            return;
        }
        for (List<LngLatAlt> ring : coordinates) {
            if (!ring.isEmpty()) continue;
            return;
        }
        if (coordinates.size() == 1) {
            Way way = this.createWay(coordinates.get(0));
            this.fillTagsFromFeature(feature, (OsmPrimitive)way);
        } else if (coordinates.size() > 1) {
            Relation multipolygon = new Relation();
            multipolygon.put("type", "multipolygon");
            Way way = this.createWay(coordinates.get(0));
            multipolygon.addMember(new RelationMember("outer", (OsmPrimitive)way));
            for (List<LngLatAlt> interiorRings : coordinates.subList(1, coordinates.size())) {
                way = this.createWay(interiorRings);
                multipolygon.addMember(new RelationMember("inner", (OsmPrimitive)way));
            }
            this.fillTagsFromFeature(feature, (OsmPrimitive)multipolygon);
            this.dataSet.addPrimitive((OsmPrimitive)multipolygon);
        }
    }

    private void fillTagsFromFeature(Feature feature, OsmPrimitive primitive) {
        if (feature != null) {
            primitive.setKeys(this.getTags(feature));
        }
    }

    private Node createNode(LngLatAlt point) {
        double[] pt = new double[]{point.getLongitude(), point.getLatitude()};
        LatLon latlon = new LatLon(pt[1], pt[0]);
        Node node = new Node(latlon);
        this.dataSet.addPrimitive((OsmPrimitive)node);
        return node;
    }

    private Way createWay(List<LngLatAlt> coordinates) {
        if (coordinates.isEmpty()) {
            return null;
        }
        Way way = new Way();
        ArrayList<Node> nodes = new ArrayList<Node>(coordinates.size());
        for (LngLatAlt point : coordinates) {
            Node node = this.createNode(point);
            nodes.add(node);
        }
        way.setNodes(nodes);
        this.dataSet.addPrimitive((OsmPrimitive)way);
        return way;
    }

    private Map<String, String> getTags(Feature feature) {
        Map<String, Object> properties = feature.getProperties();
        TreeMap<String, String> tags = new TreeMap<String, String>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            tags.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return tags;
    }

    private Bounds mergeBounds(Bounds bounds, OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Node) {
            return this.mergeBounds(bounds, ((Node)osmPrimitive).getCoor());
        }
        return bounds;
    }

    private Bounds mergeBounds(Bounds bounds, LatLon coords) {
        if (bounds == null) {
            return new Bounds(coords);
        }
        bounds.extend(coords);
        return bounds;
    }

    public static class BoundedDataSet {
        private final DataSet dataSet;
        private final Bounds bounds;

        public BoundedDataSet(DataSet dataSet, Bounds bounds) {
            this.dataSet = dataSet;
            this.bounds = bounds;
        }

        public Bounds getBounds() {
            return this.bounds;
        }

        public DataSet getDataSet() {
            return this.dataSet;
        }
    }
}

