/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.condition;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.condition.BeforeConditionAbortedException;
import uk.co.caprica.vlcj.player.condition.UnexpectedErrorConditionException;
import uk.co.caprica.vlcj.player.condition.UnexpectedFinishedConditionException;

public abstract class Condition<T>
extends MediaPlayerEventAdapter {
    private final Logger logger = LoggerFactory.getLogger(Condition.class);
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private final AtomicReference<ResultStatus> resultStatus = new AtomicReference();
    private final AtomicReference<T> result = new AtomicReference();
    private final AtomicBoolean finished = new AtomicBoolean();
    protected final MediaPlayer mediaPlayer;
    private boolean used;

    public Condition(MediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
        mediaPlayer.addMediaPlayerEventListener(this);
    }

    public final T await() throws InterruptedException, UnexpectedErrorConditionException, UnexpectedFinishedConditionException {
        this.logger.debug("await()");
        if (!this.used) {
            this.used = true;
            if (this.onBefore()) {
                this.completionLatch.await();
                switch (this.resultStatus.get()) {
                    case NORMAL: {
                        this.onAfter(this.result.get());
                        return this.result.get();
                    }
                    case ERROR: {
                        throw new UnexpectedErrorConditionException();
                    }
                    case FINISHED: {
                        throw new UnexpectedFinishedConditionException();
                    }
                }
                throw new IllegalStateException("Unexpected result status: " + (Object)((Object)this.resultStatus.get()));
            }
            throw new BeforeConditionAbortedException();
        }
        throw new IllegalStateException("Can not re-use Condition instances, create a new instance instead");
    }

    protected final void ready() {
        this.logger.debug("ready()");
        this.ready(null);
    }

    protected final void ready(T result) {
        this.logger.debug("ready(result={})", (Object)result);
        if (!this.finished.getAndSet(true)) {
            this.logger.debug("Finished");
            this.result.set(result);
            this.release(ResultStatus.NORMAL);
        } else {
            this.logger.debug("Already finished");
        }
    }

    protected final void error() {
        this.logger.debug("error()");
        this.release(ResultStatus.ERROR);
    }

    protected final void finished() {
        this.logger.debug("finished()");
        this.release(ResultStatus.FINISHED);
    }

    protected boolean onBefore() {
        return true;
    }

    protected void onAfter(T result) {
    }

    private void release(ResultStatus resultStatus) {
        this.mediaPlayer.removeMediaPlayerEventListener(this);
        this.resultStatus.set(resultStatus);
        this.completionLatch.countDown();
    }

    private static enum ResultStatus {
        NORMAL,
        ERROR,
        FINISHED;

    }
}

