/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.Serializer;
import org.mapdb.Utils;

public class CacheHashTable
extends EngineWrapper
implements Engine {
    protected final ReentrantLock[] locks = Utils.newLocks(32);
    protected HashItem[] items;
    protected final int cacheMaxSize;
    protected final long hashSalt = Utils.RANDOM.nextLong();

    public CacheHashTable(Engine engine, int cacheMaxSize) {
        super(engine);
        this.items = new HashItem[cacheMaxSize];
        this.cacheMaxSize = cacheMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        long recid = this.getWrappedEngine().put(value, serializer);
        int pos = this.position(recid);
        try {
            Utils.lock(this.locks, (long)pos);
            CacheHashTable.checkClosed(this.items)[this.position((long)recid)] = new HashItem(recid, value);
        }
        finally {
            Utils.unlock(this.locks, (long)pos);
        }
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        int pos = this.position(recid);
        HashItem[] items2 = CacheHashTable.checkClosed(this.items);
        HashItem item = items2[pos];
        if (item != null && recid == item.key) {
            return (A)item.val;
        }
        try {
            Utils.lock(this.locks, (long)pos);
            A value = this.getWrappedEngine().get(recid, serializer);
            if (value != null) {
                items2[pos] = new HashItem(recid, value);
            }
            A a = value;
            return a;
        }
        finally {
            Utils.unlock(this.locks, (long)pos);
        }
    }

    private int position(long recid) {
        return Math.abs(Utils.longHash(recid ^ this.hashSalt)) % this.cacheMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        int pos = this.position(recid);
        try {
            Utils.lock(this.locks, (long)pos);
            CacheHashTable.checkClosed(this.items)[pos] = new HashItem(recid, value);
            this.getWrappedEngine().update(recid, value, serializer);
        }
        finally {
            Utils.unlock(this.locks, (long)pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        int pos = this.position(recid);
        try {
            HashItem[] items2 = CacheHashTable.checkClosed(this.items);
            Utils.lock(this.locks, (long)pos);
            HashItem item = items2[pos];
            if (item != null && item.key == recid) {
                if (item.val == expectedOldValue || item.val.equals(expectedOldValue)) {
                    items2[pos] = new HashItem(recid, newValue);
                    this.getWrappedEngine().update(recid, newValue, serializer);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean ret = this.getWrappedEngine().compareAndSwap(recid, expectedOldValue, newValue, serializer);
            if (ret) {
                items2[pos] = new HashItem(recid, newValue);
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            Utils.unlock(this.locks, (long)pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        int pos = this.position(recid);
        try {
            Utils.lock(this.locks, (long)pos);
            this.getWrappedEngine().delete(recid, serializer);
            HashItem[] items2 = CacheHashTable.checkClosed(this.items);
            HashItem item = items2[pos];
            if (item != null && recid == item.key) {
                this.items[pos] = null;
            }
        }
        finally {
            Utils.unlock(this.locks, (long)pos);
        }
    }

    @Override
    public void close() {
        super.close();
        this.items = null;
    }

    @Override
    public void rollback() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = null;
        }
        super.rollback();
    }

    private static class HashItem {
        final long key;
        final Object val;

        private HashItem(long key, Object val) {
            this.key = key;
            this.val = val;
        }
    }
}

