/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.gpx;

import java.util.Collection;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.elevation.gpx.IGpxVisitor;

public final class GpxIterator {
    private GpxIterator() {
    }

    public static void visit(GpxData data, IGpxVisitor visitor) {
        if (data == null) {
            return;
        }
        if (visitor == null) {
            return;
        }
        if (data.isEmpty()) {
            return;
        }
        visitor.beginWayPoints();
        GpxIterator.visitSingleWaypoints(data, visitor);
        visitor.endWayPoints();
        if (data.hasRoutePoints()) {
            for (GpxRoute rte : data.routes) {
                GpxIterator.visitRoute(visitor, rte);
            }
        }
        for (GpxTrack trk : data.tracks) {
            GpxIterator.visitTrack(visitor, trk);
        }
    }

    public static void visit(GpxTrack track, IGpxVisitor visitor) {
        GpxIterator.visitTrack(visitor, track);
    }

    public static void visit(GpxRoute route, IGpxVisitor visitor) {
        GpxIterator.visitRoute(visitor, route);
    }

    private static void visitTrack(IGpxVisitor visitor, GpxTrack trk) {
        if (trk == null) {
            return;
        }
        if (visitor == null) {
            return;
        }
        Collection segments = trk.getSegments();
        if (segments != null) {
            visitor.beginTrack(trk);
            for (GpxTrackSegment segment : segments) {
                Collection waypts = segment.getWayPoints();
                if (waypts == null) continue;
                visitor.beginTrackSegment(trk, segment);
                for (WayPoint wayPoint : waypts) {
                    visitor.visitTrackPoint(wayPoint, trk, segment);
                }
                visitor.endTrackSegment(trk, segment);
            }
            visitor.endTrack(trk);
        }
    }

    private static void visitRoute(IGpxVisitor visitor, GpxRoute route) {
        if (route == null) {
            return;
        }
        if (visitor == null) {
            return;
        }
        visitor.beginWayPoints();
        for (WayPoint wpt : route.routePoints) {
            visitor.visitRoutePoint(wpt, route);
        }
        visitor.endWayPoints();
    }

    private static void visitSingleWaypoints(GpxData data, IGpxVisitor visitor) {
        if (data.waypoints != null) {
            for (WayPoint wpt : data.waypoints) {
                visitor.visitWayPoint(wpt);
            }
        }
    }
}

