/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.OSMEntityBase;
import org.openstreetmap.josm.plugins.fixAddresses.OSMStreetSegment;
import org.openstreetmap.josm.plugins.fixAddresses.TagUtils;

public class OSMStreet
extends OSMEntityBase {
    private List<IOSMEntity> children;
    private List<OSMAddress> addresses;

    public OSMStreet(OsmPrimitive osmPrimitive) {
        super(osmPrimitive);
    }

    @Override
    public List<IOSMEntity> getChildren() {
        return this.children;
    }

    public void addStreetSegment(OSMStreetSegment segment) {
        this.lazyCreateChildren();
        this.children.add(segment);
        Collections.sort(this.children);
    }

    private void lazyCreateChildren() {
        if (this.children == null) {
            this.children = new ArrayList<IOSMEntity>();
        }
    }

    public void addAddress(OSMAddress aNode) {
        this.lazyCreateAddresses();
        this.addresses.add(aNode);
    }

    private void lazyCreateAddresses() {
        if (this.addresses == null) {
            this.addresses = new ArrayList<OSMAddress>();
        }
    }

    public boolean hasAddresses() {
        return this.addresses != null && this.addresses.size() > 0;
    }

    public List<OSMAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<OSMAddress> addresses) {
        this.addresses = addresses;
    }

    public int getNumberOfAddresses() {
        if (this.addresses == null) {
            return 0;
        }
        return this.addresses.size();
    }

    public int getNumberOfSegments() {
        if (this.children == null) {
            return 0;
        }
        int sc = 0;
        for (IOSMEntity node : this.children) {
            if (!(node instanceof OSMStreetSegment)) continue;
            ++sc;
        }
        return sc;
    }

    public String getType() {
        ArrayList<String> types = new ArrayList<String>();
        for (IOSMEntity seg : this.getChildren()) {
            String val;
            OsmPrimitive osmPrim = seg.getOsmObject();
            if (!TagUtils.hasHighwayTag(osmPrim) || types.contains(val = osmPrim.get("highway"))) continue;
            types.add(val);
        }
        StringBuffer sb = new StringBuffer(20);
        for (String string : types) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(string);
        }
        return sb.toString();
    }

    public boolean hasAssociatedStreetRelation() {
        OsmPrimitive osm = this.getOsmObject();
        for (OsmPrimitive refs : osm.getReferrers()) {
            Relation rel;
            if (!(refs instanceof Relation) || !TagUtils.isAssociatedStreetRelation(rel = (Relation)refs)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.getName());
        if (this.children != null) {
            sb.append(String.format(", %d segments", this.children.size()));
        }
        if (this.addresses != null) {
            sb.append(String.format(", %d address entries", this.addresses.size()));
        }
        return sb.toString();
    }
}

