/*
 * Decompiled with CFR 0.152.
 */
package org.insignificant.josm.plugins.imagewaypoint;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.insignificant.josm.plugins.imagewaypoint.IImageChangeListener;
import org.insignificant.josm.plugins.imagewaypoint.ImageChangeListener;
import org.insignificant.josm.plugins.imagewaypoint.ImageComponent;
import org.insignificant.josm.plugins.imagewaypoint.ImageEntries;
import org.insignificant.josm.plugins.imagewaypoint.actions.NextAction;
import org.insignificant.josm.plugins.imagewaypoint.actions.PreviousAction;
import org.insignificant.josm.plugins.imagewaypoint.actions.RotateLeftAction;
import org.insignificant.josm.plugins.imagewaypoint.actions.RotateRightAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class ImageWayPointDialog
extends ToggleDialog {
    final ImageComponent imageDisplay;
    private final Action previousAction = new PreviousAction();
    private final Action nextAction = new NextAction();
    private final Action rotateLeftAction = new RotateLeftAction();
    private final Action rotateRightAction = new RotateRightAction();
    private final IImageChangeListener listener;

    public ImageWayPointDialog() {
        super(I18n.tr((String)"WayPoint Image", (Object[])new Object[0]), "imagewaypoint", I18n.tr((String)"Display non-geotagged photos", (Object[])new Object[0]), Shortcut.registerShortcut((String)"subwindow:imagewaypoint", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"WayPoint Image", (Object[])new Object[0])}), (int)89, (int)5007), 200);
        JButton previousButton = new JButton(this.previousAction);
        JButton nextButton = new JButton(this.nextAction);
        JButton rotateLeftButton = new JButton(this.rotateLeftAction);
        JButton rotateRightButton = new JButton(this.rotateRightAction);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(previousButton);
        buttonPanel.add(nextButton);
        buttonPanel.add(rotateLeftButton);
        buttonPanel.add(rotateRightButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.imageDisplay = new ImageComponent();
        mainPanel.add((Component)buttonPanel, "South");
        mainPanel.add((Component)this.imageDisplay, "Center");
        this.listener = new ImageChangeListener(this);
        ImageEntries.getInstance().addListener(this.listener);
        this.updateGUI();
        this.add(mainPanel);
    }

    void updateGUI() {
        this.previousAction.setEnabled(ImageEntries.getInstance().hasPrevious());
        this.nextAction.setEnabled(ImageEntries.getInstance().hasNext());
        this.rotateLeftAction.setEnabled(null != ImageEntries.getInstance().getCurrentImageEntry());
        this.rotateRightAction.setEnabled(null != ImageEntries.getInstance().getCurrentImageEntry());
        if (null != MainApplication.getMap()) {
            MainApplication.getMap().repaint();
        }
    }
}

