/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class PartiallyOrderedSet<E>
extends AbstractSet<E> {
    private Map<E, DirectedGraphNode<E>> elementsToNodes = new LinkedHashMap<E, DirectedGraphNode<E>>();

    @Override
    public boolean add(E e) {
        if (this.elementsToNodes.containsKey(e)) {
            return false;
        }
        this.elementsToNodes.put(e, new DirectedGraphNode<E>(e));
        return true;
    }

    @Override
    public boolean remove(Object o) {
        DirectedGraphNode<E> node = this.elementsToNodes.remove(o);
        if (node == null) {
            return false;
        }
        node.clear();
        return true;
    }

    public boolean setOrder(E source, E target) {
        DirectedGraphNode<E> sourceNode = this.elementsToNodes.get(source);
        DirectedGraphNode<E> targetNode = this.elementsToNodes.get(target);
        if (sourceNode == null) {
            throw new IllegalArgumentException("Could not find source node in the set: " + source);
        }
        if (targetNode == null) {
            throw new IllegalArgumentException("Could not find target node in the set: " + target);
        }
        return sourceNode.addOutgoing(targetNode);
    }

    public boolean clearOrder(E source, E target) {
        DirectedGraphNode<E> sourceNode = this.elementsToNodes.get(source);
        DirectedGraphNode<E> targetNode = this.elementsToNodes.get(target);
        if (sourceNode == null) {
            throw new IllegalArgumentException("Could not find source node in the set: " + source);
        }
        if (targetNode == null) {
            throw new IllegalArgumentException("Could not find target node in the set: " + target);
        }
        boolean result = false;
        result |= sourceNode.removeOutgoing(targetNode);
        return result |= targetNode.removeOutgoing(sourceNode);
    }

    @Override
    public Iterator<E> iterator() {
        return new TopologicalSortIterator();
    }

    @Override
    public int size() {
        return this.elementsToNodes.size();
    }

    class TopologicalSortIterator
    implements Iterator<E> {
        LinkedList<DirectedGraphNode<E>> sources = new LinkedList();
        Map<DirectedGraphNode<E>, Countdown> residualInDegrees = new LinkedHashMap();

        public TopologicalSortIterator() {
            for (DirectedGraphNode node : PartiallyOrderedSet.this.elementsToNodes.values()) {
                int inDegree = node.getInDegree();
                if (inDegree == 0) {
                    this.sources.add(node);
                    continue;
                }
                this.residualInDegrees.put(node, new Countdown(inDegree));
            }
            if (this.sources.size() == 0 && !this.residualInDegrees.isEmpty()) {
                this.throwLoopException();
            }
        }

        private void throwLoopException() {
            String message = "Some of the partial order relationship form a loop: " + this.residualInDegrees.keySet();
            throw new IllegalStateException(message);
        }

        @Override
        public boolean hasNext() {
            if (this.sources.isEmpty() && !this.residualInDegrees.isEmpty()) {
                this.throwLoopException();
            }
            return !this.sources.isEmpty();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            DirectedGraphNode next = this.sources.removeFirst();
            for (DirectedGraphNode out : next.getOutgoings()) {
                Countdown countdown = this.residualInDegrees.get(out);
                if (countdown.decrement() != 0) continue;
                this.sources.add(out);
                this.residualInDegrees.remove(out);
            }
            return next.getValue();
        }
    }

    static final class Countdown {
        int value;

        public Countdown(int value) {
            this.value = value;
        }

        public int decrement() {
            return --this.value;
        }
    }

    class DirectedGraphNode<E> {
        E element;
        Set<DirectedGraphNode<E>> outgoings = new HashSet<DirectedGraphNode<E>>();
        Set<DirectedGraphNode<E>> ingoings = new HashSet<DirectedGraphNode<E>>();

        public DirectedGraphNode(E element) {
            this.element = element;
        }

        public void clear() {
            this.outgoings.clear();
            this.ingoings.clear();
        }

        public boolean removeOutgoing(DirectedGraphNode<E> targetNode) {
            targetNode.ingoings.remove(this);
            return this.outgoings.remove(targetNode);
        }

        public boolean addOutgoing(DirectedGraphNode<E> targetNode) {
            targetNode.ingoings.add(this);
            targetNode.outgoings.remove(this);
            return this.outgoings.add(targetNode);
        }

        public Collection<DirectedGraphNode<E>> getOutgoings() {
            return this.outgoings;
        }

        public E getValue() {
            return this.element;
        }

        public int getInDegree() {
            return this.ingoings.size();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            sb.append(this.element);
            if (this.outgoings.size() > 0) {
                sb.append(" -> (");
                for (DirectedGraphNode<E> outgoing : this.outgoings) {
                    sb.append(outgoing.element).append(",");
                }
                sb.setCharAt(sb.length() - 1, ')');
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

