/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class MatrixMultQuad {
    public static void multQuad1(DenseMatrix64F A, DenseMatrix64F B, DenseMatrix64F out) {
        if (A.numCols != B.numCols || A.numCols != B.numRows || A.numRows != out.numRows || A.numRows != out.numCols) {
            throw new IllegalArgumentException("Incompatible matrix shapes");
        }
        CommonOps.fill(out, 0.0);
        for (int i = 0; i < A.numRows; ++i) {
            for (int j = 0; j < A.numCols; ++j) {
                double total = 0.0;
                int indexA = i * A.numCols;
                int indexB = j;
                int end = indexA + A.numCols;
                while (indexA < end) {
                    total += A.data[indexA] * B.data[indexB];
                    ++indexA;
                    indexB += B.numCols;
                }
                int indexOut = i * out.numCols;
                indexA = j;
                end = indexOut + A.numRows;
                while (indexOut < end) {
                    int n = indexOut++;
                    out.data[n] = out.data[n] + total * A.data[indexA];
                    indexA += A.numCols;
                }
            }
        }
    }
}

