/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tracer2;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.tracer2.ConnectWays;
import org.openstreetmap.josm.plugins.tracer2.TagValues;
import org.openstreetmap.josm.plugins.tracer2.TracerPlugin;
import org.openstreetmap.josm.plugins.tracer2.preferences.ServerParam;
import org.openstreetmap.josm.plugins.tracer2.preferences.ServerParamList;
import org.openstreetmap.josm.plugins.tracer2.preferences.ServerParamSelectDialog;
import org.openstreetmap.josm.plugins.tracer2.server.GetTrace;
import org.openstreetmap.josm.plugins.tracer2.server.GetVersion;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

class TracerAction
extends MapMode
implements MouseListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private static boolean s_bServerVersionOK = false;
    protected boolean m_bCancel;
    private boolean m_bCtrl;
    private boolean m_bAlt;
    private boolean m_bShift;
    private boolean m_bEnter = false;
    private TagValues m_oTagValues = new TagValues();
    TracerPlugin m_oPlugin;

    TracerAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Tracer2", (Object[])new Object[0]), "tracer2-sml", I18n.tr((String)"Tracer2.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:tracer2", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Tracer2", (Object[])new Object[0])}), (int)84, (int)5003), mapFrame, TracerAction.getCursor());
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Collection selection = this.getLayerManager().getEditDataSet().getSelected();
        ArrayList<ChangePropertyCommand> commands = new ArrayList<ChangePropertyCommand>();
        if (!this.checkActiveServerParam()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 37: {
                this.m_oTagValues.left();
                break;
            }
            case 38: {
                this.m_oTagValues.up();
                break;
            }
            case 39: {
                this.m_oTagValues.right();
                break;
            }
            case 40: {
                this.m_oTagValues.down();
                break;
            }
            default: {
                return;
            }
        }
        if (selection.isEmpty()) {
            return;
        }
        String strTag = this.m_oTagValues.getTag();
        String strTagValue = this.m_oTagValues.getTagValue();
        if (strTag != null && strTagValue != null) {
            commands.add(new ChangePropertyCommand(selection, strTag, strTagValue));
            if (!commands.isEmpty()) {
                Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Change tag {0} to {1}", (Object[])new Object[]{strTag, strTagValue}), commands));
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void enterMode() {
        this.m_bEnter = true;
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        Main.map.mapView.setCursor(TracerAction.getCursor());
        Main.map.mapView.addMouseListener((MouseListener)this);
        Main.map.mapView.addKeyListener((KeyListener)this);
    }

    public void exitMode() {
        this.m_bEnter = false;
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeKeyListener((KeyListener)this);
    }

    private static Cursor getCursor() {
        return ImageProvider.getCursor((String)"crosshair", (String)"tracer2-sml");
    }

    protected void traceAsync(Point clickPoint) {
        this.m_bCancel = false;
        final LatLon pos = Main.map.mapView.getLatLon(clickPoint.x, clickPoint.y);
        try {
            PleaseWaitRunnable tracerTask = new PleaseWaitRunnable(I18n.tr((String)"Tracing", (Object[])new Object[0])){

                protected void realRun() throws SAXException {
                    TracerAction.this.traceSync(pos, this.progressMonitor.createSubTaskMonitor(-1, false));
                }

                protected void finish() {
                }

                protected void cancel() {
                    TracerAction.this.cancel();
                }
            };
            Thread executeTraceThread = new Thread((Runnable)tracerTask);
            executeTraceThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void tagBuilding(Way way) {
        String strTag = this.m_oTagValues.getTag();
        String strTagValue = this.m_oTagValues.getTagValue();
        if (strTag != null && strTagValue != null && !this.m_bCtrl) {
            way.put(strTag, strTagValue);
        }
    }

    private boolean checkServerVersion() {
        int nMajor = 1;
        int nMinor = 1;
        if (!s_bServerVersionOK) {
            GetVersion oGetVersion = new GetVersion();
            oGetVersion.start();
            for (int nRetray = 500; oGetVersion.isAlive() && nRetray > 0; --nRetray) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            if (oGetVersion.m_nVersionMajor < 0 || oGetVersion.m_nVersionMinor < 0) {
                return false;
            }
            if (oGetVersion.m_nVersionMajor != nMajor) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The Tracer2Server version isn''t compatible with this plugin. Please download version {0} from\n{1}.", (Object[])new Object[]{nMajor + ".x", "http://sourceforge.net/projects/tracer2server/"}), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
                return false;
            }
            if (oGetVersion.m_nVersionMinor < nMinor) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"New version of Tracer2Server is available. For best results please upgrade to version {0}.", (Object[])new Object[]{nMajor + "." + nMinor}), I18n.tr((String)"Information", (Object[])new Object[0]), 1);
            }
            s_bServerVersionOK = true;
        }
        return true;
    }

    private boolean checkActiveServerParam() {
        ServerParam param;
        if (!this.checkServerVersion()) {
            return false;
        }
        if (this.m_bEnter || TracerPlugin.s_oPlugin.m_oParamList.getActivParam() == null) {
            ServerParamList listParam = TracerPlugin.s_oPlugin.m_oParamList;
            List<ServerParam> listEnableParam = listParam.getEnableParamList();
            if (listEnableParam == null || listEnableParam.size() == 0) {
                listParam.setActivParam(null);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No set of parameter is active!", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
                return false;
            }
            if (listEnableParam.size() == 1) {
                ServerParam param2 = listEnableParam.get(0);
                listParam.setActivParam(param2);
                this.m_oTagValues.readBuildingTags(param2);
                return true;
            }
            ServerParamSelectDialog dialog = new ServerParamSelectDialog(listEnableParam, listParam.getActivParam());
            if (dialog.getShow()) {
                JOptionPane pane = new JOptionPane(dialog, -1, 2);
                JDialog dlg = pane.createDialog(Main.parent, I18n.tr((String)"Tracer2", (Object[])new Object[0]) + " - " + I18n.tr((String)"Select parameter", (Object[])new Object[0]));
                dlg.setVisible(true);
                Object obj = pane.getValue();
                dlg.dispose();
                if (obj != null && (Integer)obj == 0) {
                    TracerPlugin.s_oPlugin.m_oParamList.setActivParam(dialog.getSelectedParam());
                } else {
                    return false;
                }
            }
        }
        if ((param = TracerPlugin.s_oPlugin.m_oParamList.getActivParam()) == null) {
            return false;
        }
        this.m_bEnter = false;
        this.m_oTagValues.readBuildingTags(param);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceSync(LatLon pos, ProgressMonitor progressMonitor) {
        LinkedList<Command> commands = new LinkedList<Command>();
        progressMonitor.beginTask(null, 3);
        try {
            ArrayList<Object> coordList;
            if (!this.checkActiveServerParam()) {
                return;
            }
            ServerParam param = TracerPlugin.s_oPlugin.m_oParamList.getActivParam();
            GetTrace oTraceSimple = new GetTrace(pos, param);
            oTraceSimple.start();
            try {
                while (oTraceSimple.isAlive()) {
                    Thread.sleep(50L);
                    if (!this.m_bCancel) continue;
                    oTraceSimple.interrupt();
                    break;
                }
                coordList = oTraceSimple.m_listLatLon;
            }
            catch (Exception e) {
                coordList = new ArrayList();
            }
            if (this.m_bCancel || coordList.size() == 0) {
                return;
            }
            Way way = new Way();
            Node firstNode = null;
            for (LatLon latLon : coordList) {
                Node node = new Node(latLon);
                if (firstNode == null) {
                    firstNode = node;
                }
                way.addNode(node);
            }
            way.addNode(firstNode);
            this.tagBuilding(way);
            commands.add(ConnectWays.connect(way, pos, param, this.m_bCtrl, this.m_bAlt));
            if (!commands.isEmpty()) {
                String strCommand = ConnectWays.s_bAddNewWay ? I18n.tr((String)"Tracer2: add a way with {0} points", (Object[])new Object[]{coordList.size()}) : I18n.tr((String)"Tracer2: modify way to {0} points", (Object[])new Object[]{coordList.size()});
                Main.main.undoRedo.add((Command)new SequenceCommand(strCommand, commands));
                if (this.m_bShift) {
                    this.getLayerManager().getEditDataSet().addSelected(new PrimitiveId[]{ConnectWays.s_oWay});
                } else {
                    this.getLayerManager().getEditDataSet().setSelected(new PrimitiveId[]{ConnectWays.s_oWay});
                }
            } else {
                System.out.println("Failed");
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public void cancel() {
        this.m_bCancel = true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.requestFocusInMapView();
        this.updateKeyModifiers(e);
        if (e.getButton() == 1) {
            this.traceAsync(e.getPoint());
        }
    }

    protected void updateKeyModifiers(MouseEvent e) {
        this.m_bCtrl = (e.getModifiers() & 2) != 0;
        this.m_bAlt = (e.getModifiers() & 0x28) != 0;
        this.m_bShift = (e.getModifiers() & 1) != 0;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

