/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmobjinfo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.osmobjinfo.OSMObjInfoActions;
import org.openstreetmap.josm.plugins.osmobjinfo.OSMObjInfoFunctions;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class OSMObjInfotDialog
extends ToggleDialog {
    protected JLabel lbUser;
    protected JLabel lbVersion;
    protected JLabel lbIdobj;
    protected JLabel lbTimestamp;
    protected JLabel lbIdChangeset;
    protected JLabel lbLinkUser;
    protected JLabel lbLinnkIdobj;
    protected JLabel lbLinkMapillary;
    protected JLabel lbLinkiD;
    protected JLabel lbLinkOSMcamp;
    protected JLabel lbLinkIdChangeset;
    protected JLabel lbCopyUser;
    protected JLabel lbCopyIdobj;
    protected JLabel lbCopyIdChangeset;
    protected JLabel lbNeisUser;
    protected JLabel lbChangesetMap;
    protected JLabel lbOsmDeepHistory;
    protected JLabel lbUserOsmComments;
    protected JLabel lbCoordinates;
    protected JLabel lbOsmcamp;
    String typeObj;
    String user = "";
    String version = "";
    String idObject = "";
    String timestamp = "";
    String idchangeset = "";
    String coordinates = "";

    public OSMObjInfotDialog() {
        super(I18n.tr((String)"OpenStreetMap obj info", (Object[])new Object[0]), "iconosmobjid", I18n.tr((String)"Open OpenStreetMap obj info window", (Object[])new Object[0]), Shortcut.registerShortcut((String)"osmObjInfo", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"OpenStreetMap obj info", (Object[])new Object[0])}), (int)73, (int)5010), 90);
        JPanel panel = new JPanel(new GridLayout(0, 2));
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.add(new JLabel(I18n.tr((String)"User", (Object[])new Object[0])));
        panel.add(this.buildUser());
        panel.add(new JLabel(I18n.tr((String)"Changeset", (Object[])new Object[0])));
        panel.add(this.buildChangeset());
        panel.add(new JLabel(I18n.tr((String)"Object Id", (Object[])new Object[0])));
        panel.add(this.buildidObject());
        panel.add(new JLabel(I18n.tr((String)"Version", (Object[])new Object[0])));
        this.lbVersion = new JLabel();
        panel.add(this.lbVersion);
        panel.add(new JLabel(I18n.tr((String)"Date", (Object[])new Object[0])));
        this.lbTimestamp = new JLabel();
        panel.add(this.lbTimestamp);
        panel.add(new JLabel(I18n.tr((String)"Images", (Object[])new Object[0])));
        this.lbCoordinates = new JLabel();
        this.lbOsmcamp = new JLabel();
        panel.add(this.MapillaryImages());
        this.createLayout(panel, false, Arrays.asList(new SideButton[0]));
        DataSet.addSelectionListener((SelectionChangedListener)new SelectionChangedListener(){

            public void selectionChanged(Collection<? extends OsmPrimitive> clctn) {
                OSMObjInfotDialog.this.selection(clctn);
            }
        });
        Main.map.mapView.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OSMObjInfotDialog.this.getInfoNotes(e);
            }
        });
    }

    private JPanel buildUser() {
        JPanel jpUser = new JPanel(new BorderLayout());
        this.lbUser = new JLabel();
        this.lbLinkUser = new JLabel(ImageProvider.get((String)"dialogs", (String)"link.png"));
        this.lbCopyUser = new JLabel(ImageProvider.get((String)"dialogs", (String)"copy.png"));
        this.lbNeisUser = new JLabel(ImageProvider.get((String)"dialogs", (String)"neisuser.png"));
        this.lbUserOsmComments = new JLabel(ImageProvider.get((String)"dialogs", (String)"userosmcomments.png"));
        this.lbUser.setCursor(new Cursor(12));
        this.lbLinkUser.setCursor(new Cursor(12));
        this.lbCopyUser.setCursor(new Cursor(12));
        this.lbNeisUser.setCursor(new Cursor(12));
        this.lbUserOsmComments.setCursor(new Cursor(12));
        this.lbUser.setForeground(Color.BLUE);
        JPanel jpuseroptions = new JPanel(new GridLayout(1, 4, 5, 5));
        jpuseroptions.add(this.lbCopyUser);
        jpuseroptions.add(this.lbNeisUser);
        jpuseroptions.add(this.lbUserOsmComments);
        jpuseroptions.add(this.lbLinkUser);
        jpUser.add((Component)this.lbUser, "Before");
        jpUser.add((Component)jpuseroptions, "After");
        this.lbUser.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OSMObjInfoFunctions.selectbyUser(OSMObjInfotDialog.this.lbUser.getText());
            }
        });
        this.lbLinkUser.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OSMObjInfoActions.openinBrowserUser(OSMObjInfotDialog.this.lbUser.getText());
            }
        });
        this.lbCopyUser.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OSMObjInfoActions.copyUser(OSMObjInfotDialog.this.lbUser.getText());
            }
        });
        this.lbNeisUser.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OSMObjInfoActions.openinBrowserUserNeis(OSMObjInfotDialog.this.lbUser.getText());
            }
        });
        this.lbUserOsmComments.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OSMObjInfoActions.openinBrowserUserOsmComments(OSMObjInfotDialog.this.lbUser.getText());
            }
        });
        return jpUser;
    }

    private JPanel buildChangeset() {
        JPanel jpChangeset = new JPanel(new BorderLayout());
        this.lbIdChangeset = new JLabel();
        this.lbLinkIdChangeset = new JLabel(ImageProvider.get((String)"dialogs", (String)"link.png"));
        this.lbCopyIdChangeset = new JLabel(ImageProvider.get((String)"dialogs", (String)"copy.png"));
        this.lbChangesetMap = new JLabel(ImageProvider.get((String)"dialogs", (String)"changesetmap.png"));
        this.lbIdChangeset.setCursor(new Cursor(12));
        this.lbLinkIdChangeset.setCursor(new Cursor(12));
        this.lbCopyIdChangeset.setCursor(new Cursor(12));
        this.lbChangesetMap.setCursor(new Cursor(12));
        this.lbIdChangeset.setForeground(Color.BLUE);
        JPanel jpchOptions = new JPanel(new GridLayout(1, 3, 5, 5));
        jpchOptions.add(this.lbCopyIdChangeset);
        jpchOptions.add(this.lbChangesetMap);
        jpchOptions.add(this.lbLinkIdChangeset);
        jpChangeset.add((Component)this.lbIdChangeset, "Before");
        jpChangeset.add((Component)jpchOptions, "After");
        this.lbIdChangeset.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int idchangeset = Integer.parseInt(OSMObjInfotDialog.this.lbIdChangeset.getText());
                OSMObjInfoFunctions.selectbyChangesetId(idchangeset);
            }
        });
        this.lbLinkIdChangeset.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OSMObjInfoActions.openinBrowserChangeset(OSMObjInfotDialog.this.lbIdChangeset.getText());
            }
        });
        this.lbCopyIdChangeset.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OSMObjInfoActions.copyChangeset(OSMObjInfotDialog.this.lbIdChangeset.getText());
            }
        });
        this.lbChangesetMap.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OSMObjInfoActions.openinBrowserChangesetMap(OSMObjInfotDialog.this.lbIdChangeset.getText());
            }
        });
        return jpChangeset;
    }

    private JPanel buildidObject() {
        JPanel jpIdobj = new JPanel(new BorderLayout());
        this.lbIdobj = new JLabel();
        this.lbLinnkIdobj = new JLabel(ImageProvider.get((String)"dialogs", (String)"link.png"));
        this.lbCopyIdobj = new JLabel(ImageProvider.get((String)"dialogs", (String)"copy.png"));
        this.lbOsmDeepHistory = new JLabel(ImageProvider.get((String)"dialogs", (String)"deephistory.png"));
        this.lbLinnkIdobj.setCursor(new Cursor(12));
        this.lbCopyIdobj.setCursor(new Cursor(12));
        this.lbOsmDeepHistory.setCursor(new Cursor(12));
        JPanel jpIdobjOptions = new JPanel(new GridLayout(1, 3, 5, 5));
        jpIdobjOptions.add(this.lbCopyIdobj);
        jpIdobjOptions.add(this.lbOsmDeepHistory);
        jpIdobjOptions.add(this.lbLinnkIdobj);
        jpIdobj.add((Component)this.lbIdobj, "Before");
        jpIdobj.add((Component)jpIdobjOptions, "After");
        this.lbLinnkIdobj.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OSMObjInfoActions.openinBrowserIdobj(OSMObjInfotDialog.this.typeObj, OSMObjInfotDialog.this.lbIdobj.getText());
            }
        });
        this.lbCopyIdobj.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OSMObjInfoActions.copyIdobj(OSMObjInfotDialog.this.typeObj, OSMObjInfotDialog.this.lbIdobj.getText());
            }
        });
        this.lbOsmDeepHistory.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OSMObjInfoActions.openinBrowserIdobjOsmDeepHistory(OSMObjInfotDialog.this.typeObj, OSMObjInfotDialog.this.lbIdobj.getText());
            }
        });
        return jpIdobj;
    }

    public void selection(Collection<? extends OsmPrimitive> selection) {
        if (selection.size() < 2) {
            this.user = "";
            this.version = "";
            this.idObject = "";
            this.timestamp = "";
            this.idchangeset = "";
            this.coordinates = "";
            for (OsmPrimitive osmPrimitive : selection) {
                if (osmPrimitive.isNew()) continue;
                this.typeObj = osmPrimitive.getType().toString();
                try {
                    this.user = osmPrimitive.getUser().getName();
                    this.timestamp = new SimpleDateFormat("yyyy/MM/dd hh:mm a").format(osmPrimitive.getTimestamp().getTime());
                }
                catch (NullPointerException e) {
                    this.user = JosmUserIdentityManager.getInstance().getUserName();
                }
                this.idObject = String.valueOf(osmPrimitive.getId());
                this.version = String.valueOf(osmPrimitive.getVersion());
                this.idchangeset = String.valueOf(osmPrimitive.getChangesetId());
                DecimalFormat df = new DecimalFormat("#.00000");
                this.coordinates = df.format(osmPrimitive.getBBox().getCenter().lat()) + "," + df.format(osmPrimitive.getBBox().getCenter().lon());
            }
            final String txtUser = this.user;
            final String string = this.version;
            final String txtIdobject = this.idObject;
            final String txtTimestamp = this.timestamp;
            final String txtIdChangeset = this.idchangeset;
            GuiHelper.runInEDT((Runnable)new Runnable(){

                @Override
                public void run() {
                    OSMObjInfotDialog.this.lbUser.setText(txtUser);
                    OSMObjInfotDialog.this.lbIdChangeset.setText(txtIdChangeset);
                    OSMObjInfotDialog.this.lbIdobj.setText(txtIdobject);
                    OSMObjInfotDialog.this.lbVersion.setText(string);
                    OSMObjInfotDialog.this.lbTimestamp.setText(txtTimestamp);
                    OSMObjInfotDialog.this.lbCoordinates.setText(OSMObjInfotDialog.this.coordinates);
                }
            });
        }
    }

    public void getInfoNotes(MouseEvent e) {
        if (!Main.getLayerManager().getLayersOfType(NoteLayer.class).isEmpty()) {
            NoteLayer noteLayer = (NoteLayer)Main.getLayerManager().getLayersOfType(NoteLayer.class).get(0);
            noteLayer.mouseClicked(e);
            if (!noteLayer.getNoteData().getNotes().isEmpty() && noteLayer.getNoteData().getSelectedNote() != null) {
                this.typeObj = "note";
                this.lbUser.setText(noteLayer.getNoteData().getSelectedNote().getFirstComment().getUser().getName());
                this.lbIdChangeset.setText("");
                if (noteLayer.getNoteData().getSelectedNote().getId() < 0L) {
                    this.lbIdobj.setText("");
                } else {
                    this.lbIdobj.setText(Long.toString(noteLayer.getNoteData().getSelectedNote().getId()));
                }
                this.lbVersion.setText("");
                this.lbTimestamp.setText(new SimpleDateFormat("yyyy/MM/dd hh:mm a").format(noteLayer.getNoteData().getSelectedNote().getCreatedAt()));
            }
        }
    }

    private JPanel MapillaryImages() {
        JPanel jpIMapillary = new JPanel(new BorderLayout());
        this.lbCoordinates = new JLabel();
        this.lbLinkiD = new JLabel(ImageProvider.get((String)"dialogs", (String)"id.png"));
        this.lbLinkMapillary = new JLabel(ImageProvider.get((String)"dialogs", (String)"mapillary.png"));
        this.lbLinkOSMcamp = new JLabel(ImageProvider.get((String)"dialogs", (String)"openstreetcam.png"));
        this.lbLinkMapillary.setCursor(new Cursor(12));
        this.lbLinkOSMcamp.setCursor(new Cursor(12));
        JPanel jpIMapillaryOptions = new JPanel(new GridLayout(1, 3, 5, 5));
        jpIMapillaryOptions.add(this.lbLinkiD);
        jpIMapillaryOptions.add(this.lbLinkMapillary);
        jpIMapillaryOptions.add(this.lbLinkOSMcamp);
        jpIMapillary.add((Component)this.lbCoordinates, "Before");
        jpIMapillary.add((Component)jpIMapillaryOptions, "After");
        this.lbLinkiD.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OSMObjInfoActions.openinBrowseriD(OSMObjInfotDialog.this.typeObj, OSMObjInfotDialog.this.lbIdobj.getText(), OSMObjInfotDialog.this.lbCoordinates.getText());
            }
        });
        this.lbLinkMapillary.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OSMObjInfoActions.openinBrowserMapillary(OSMObjInfotDialog.this.lbCoordinates.getText());
            }
        });
        this.lbLinkOSMcamp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OSMObjInfoActions.openinBrowserOpenstreetcam(OSMObjInfotDialog.this.lbCoordinates.getText());
            }
        });
        return jpIMapillary;
    }
}

