/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.index.quadtree;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.CloseableIterator;
import org.geotools.data.shapefile.index.Data;
import org.geotools.data.shapefile.index.quadtree.LazySearchIterator;
import org.geotools.data.shapefile.index.quadtree.Node;
import org.geotools.data.shapefile.index.quadtree.StoreException;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.util.logging.Logging;

public class QuadTree {
    private static final double SPLITRATIO = 0.55;
    private static final Logger LOGGER = Logging.getLogger("org.geotools.index.quadtree");
    private Node root;
    private int numShapes;
    private int maxDepth;
    private IndexFile indexfile;
    private Set iterators = new HashSet();

    public QuadTree(int numShapes, Envelope maxBounds, IndexFile file) {
        this(numShapes, 0, maxBounds, file);
    }

    public QuadTree(int numShapes, int maxDepth, Envelope maxBounds, IndexFile file) {
        if (maxDepth > 65535) {
            throw new IllegalArgumentException("maxDepth must be <= 65535");
        }
        this.numShapes = numShapes;
        this.maxDepth = maxDepth;
        if (maxBounds != null) {
            this.root = new Node(new Envelope(maxBounds));
        }
        if (maxDepth < 1) {
            int numNodes = 1;
            this.maxDepth = 0;
            while (numNodes * 4 < numShapes) {
                ++this.maxDepth;
                numNodes *= 2;
            }
        }
        this.indexfile = file;
    }

    public QuadTree(int numShapes, int maxDepth, IndexFile file) {
        this(numShapes, maxDepth, null, file);
    }

    public void insert(int recno, Envelope bounds) throws StoreException {
        this.insert(this.root, recno, bounds, this.maxDepth);
    }

    public void insert(Node node, int recno, Envelope bounds, int maxDepth) throws StoreException {
        if (maxDepth > 1 && node.getNumSubNodes() > 0) {
            Node subNode = null;
            for (int i = 0; i < node.getNumSubNodes(); ++i) {
                subNode = node.getSubNode(i);
                if (!subNode.getBounds().contains(bounds)) continue;
                this.insert(subNode, recno, bounds, maxDepth - 1);
                return;
            }
        }
        if (maxDepth > 1 && node.getNumSubNodes() < 4) {
            Envelope[] tmp = this.splitBounds(node.getBounds());
            Envelope half1 = tmp[0];
            Envelope half2 = tmp[1];
            tmp = this.splitBounds(half1);
            Envelope quad1 = tmp[0];
            Envelope quad2 = tmp[1];
            tmp = this.splitBounds(half2);
            Envelope quad3 = tmp[0];
            Envelope quad4 = tmp[1];
            Node subnode = null;
            if (quad1.contains(bounds)) {
                subnode = new Node(quad1);
            } else if (quad2.contains(bounds)) {
                subnode = new Node(quad2);
            } else if (quad3.contains(bounds)) {
                subnode = new Node(quad3);
            } else if (quad4.contains(bounds)) {
                subnode = new Node(quad4);
            }
            if (subnode != null) {
                node.addSubNode(subnode);
                this.insert(subnode, recno, bounds, maxDepth - 1);
                return;
            }
        }
        node.addShapeId(recno);
    }

    public CloseableIterator<Data> search(Envelope bounds) throws StoreException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Querying " + bounds);
        }
        try {
            return new LazySearchIterator(this, bounds);
        }
        catch (RuntimeException e) {
            LOGGER.warning("IOException occurred while reading root");
            return null;
        }
    }

    public void close(Iterator iter) throws IOException {
        this.iterators.remove(iter);
    }

    public boolean trim() throws StoreException {
        LOGGER.fine("Trimming the tree...");
        return this.trim(this.root);
    }

    private boolean trim(Node node) throws StoreException {
        int i;
        Node[] dummy = new Node[node.getNumSubNodes()];
        for (i = 0; i < node.getNumSubNodes(); ++i) {
            dummy[i] = node.getSubNode(i);
        }
        for (i = 0; i < dummy.length; ++i) {
            if (!this.trim(dummy[i])) continue;
            node.removeSubNode(dummy[i]);
        }
        if (node.getNumSubNodes() == 1 && node.getNumShapeIds() == 0) {
            Node subNode = node.getSubNode(0);
            node.clearSubNodes();
            for (int i2 = 0; i2 < subNode.getNumSubNodes(); ++i2) {
                node.addSubNode(subNode.getSubNode(i2));
            }
            node.setShapesId(subNode.getShapesId());
            node.setBounds(subNode.getBounds());
        }
        return node.getNumSubNodes() == 0 && node.getNumShapeIds() == 0;
    }

    private Envelope[] splitBounds(Envelope in) {
        Envelope[] ret = new Envelope[2];
        if (in.getMaxX() - in.getMinX() > in.getMaxY() - in.getMinY()) {
            double range = in.getMaxX() - in.getMinX();
            double calc = in.getMinX() + range * 0.55;
            ret[0] = new Envelope(in.getMinX(), calc, in.getMinY(), in.getMaxY());
            calc = in.getMaxX() - range * 0.55;
            ret[1] = new Envelope(calc, in.getMaxX(), in.getMinY(), in.getMaxY());
        } else {
            double range = in.getMaxY() - in.getMinY();
            double calc = in.getMinY() + range * 0.55;
            ret[0] = new Envelope(in.getMinX(), in.getMaxX(), in.getMinY(), calc);
            calc = in.getMaxY() - range * 0.55;
            ret[1] = new Envelope(in.getMinX(), in.getMaxX(), calc, in.getMaxY());
        }
        return ret;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public int getNumShapes() {
        return this.numShapes;
    }

    public void setNumShapes(int numShapes) {
        this.numShapes = numShapes;
    }

    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node root) {
        this.root = root;
    }

    public void close() throws StoreException {
        try {
            this.indexfile.close();
            this.root.close();
        }
        catch (IOException e) {
            throw new StoreException("error closing indexfile", e.getCause());
        }
        if (!this.iterators.isEmpty()) {
            throw new StoreException("There are still open iterators!!");
        }
    }

    public void registerIterator(Iterator object) {
        this.iterators.add(object);
    }

    public IndexFile getIndexfile() {
        return this.indexfile;
    }
}

