/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fastdraw;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.datatransfer.importers.TextTagPaster;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.plugins.fastdraw.FDSettings;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.TextTagParser;

public class FastDrawConfigDialog
extends ExtendedDialog {
    private final JLabel label1 = new JLabel(I18n.tr((String)"Epsilon multiplier", (Object[])new Object[0]));
    private final JLabel label2 = new JLabel(I18n.tr((String)"Starting Epsilon", (Object[])new Object[0]));
    private final JLabel label3 = new JLabel(I18n.tr((String)"Max points count per 1 km", (Object[])new Object[0]));
    private final JLabel label4 = new JLabel(I18n.tr((String)"Enter key mode", (Object[])new Object[0]));
    private final JLabel label5 = new JLabel(I18n.tr((String)"Auto add tags", (Object[])new Object[0]));
    private final JFormattedTextField text1 = new JFormattedTextField(NumberFormat.getInstance());
    private final JFormattedTextField text2 = new JFormattedTextField(NumberFormat.getInstance());
    private final JFormattedTextField text3 = new JFormattedTextField(NumberFormat.getInstance());
    private final JComboBox<String> combo1 = new JComboBox<String>(new String[]{I18n.tr((String)"Autosimplify", (Object[])new Object[0]), I18n.tr((String)"Simplify with initial epsilon", (Object[])new Object[0]), I18n.tr((String)"Save as is", (Object[])new Object[0])});
    private final JCheckBox snapCb = new JCheckBox(I18n.tr((String)"Snap to nodes", (Object[])new Object[0]));
    private final JCheckBox fixedClickCb = new JCheckBox(I18n.tr((String)"Add fixed points on click", (Object[])new Object[0]));
    private final JCheckBox fixedSpaceCb = new JCheckBox(I18n.tr((String)"Add fixed points on spacebar", (Object[])new Object[0]));
    private final JCheckBox allowEditExistingWaysCb = new JCheckBox(I18n.tr((String)"Allow edit existing ways", (Object[])new Object[0]));
    private final JCheckBox drawClosedCb = new JCheckBox(I18n.tr((String)"Draw closed polygons only", (Object[])new Object[0]));
    private final HistoryComboBox addTags = new HistoryComboBox();
    private final FDSettings settings;

    public FastDrawConfigDialog(FDSettings settings) {
        super(Main.parent, I18n.tr((String)"FastDraw configuration", (Object[])new Object[0]), new String[]{I18n.tr((String)"Ok", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
        this.settings = settings;
        JPanel all = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        all.setLayout(layout);
        JButton pasteButton = new JButton(new AbstractAction(I18n.tr((String)"Paste", (Object[])new Object[0]), ImageProvider.get((String)"apply")){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = ClipboardUtils.getClipboardStringContent();
                if (TextTagParser.getValidatedTagsFromText((String)s, TextTagPaster::warning) != null) {
                    FastDrawConfigDialog.this.addTags.setText(s);
                }
            }
        });
        pasteButton.setToolTipText(I18n.tr((String)"Try copying tags from properties table", (Object[])new Object[0]));
        ArrayList history = new ArrayList(Main.pref.getCollection("fastdraw.tags-history"));
        while (history.remove("")) {
        }
        this.addTags.setPossibleItems(history);
        all.add((Component)this.label1, GBC.std().insets(10, 0, 0, 0));
        all.add((Component)this.text1, GBC.eol().fill(2).insets(5, 0, 0, 5));
        all.add((Component)this.label2, GBC.std().insets(10, 0, 0, 0));
        all.add((Component)this.text2, GBC.eol().fill(2).insets(5, 0, 0, 5));
        all.add((Component)this.label3, GBC.std().insets(10, 0, 0, 0));
        all.add((Component)this.text3, GBC.eol().fill(2).insets(5, 0, 0, 5));
        all.add((Component)this.label4, GBC.std().insets(10, 0, 0, 0));
        all.add(this.combo1, GBC.eop().fill(2).insets(5, 0, 0, 5));
        all.add((Component)this.label5, GBC.std().insets(10, 0, 0, 0));
        all.add((Component)pasteButton, GBC.eop().insets(0, 0, 0, 5));
        all.add((Component)this.addTags, GBC.eop().fill(2).insets(10, 0, 5, 10));
        all.add((Component)this.snapCb, GBC.eop().insets(20, 0, 0, 0));
        all.add((Component)this.fixedClickCb, GBC.eop().insets(20, 0, 0, 0));
        all.add((Component)this.fixedSpaceCb, GBC.eop().insets(20, 0, 0, 0));
        all.add((Component)this.drawClosedCb, GBC.eop().insets(20, 0, 0, 0));
        all.add((Component)this.allowEditExistingWaysCb, GBC.eop().insets(20, 0, 0, 0));
        this.addTags.setText(settings.autoTags);
        this.text1.setValue(settings.epsilonMult);
        this.text2.setValue(settings.startingEps);
        this.text3.setValue(settings.maxPointsPerKm);
        this.snapCb.setSelected(settings.snapNodes);
        this.fixedClickCb.setSelected(settings.fixedClick);
        this.fixedSpaceCb.setSelected(settings.fixedSpacebar);
        this.drawClosedCb.setSelected(settings.drawClosed);
        this.allowEditExistingWaysCb.setSelected(settings.allowEditExistingWays);
        this.combo1.setSelectedIndex(settings.simplifyMode);
        this.setContent(all, false);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.setToolTipTexts(new String[]{I18n.tr((String)"Save settings", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
        this.setDefaultButton(1);
    }

    public ExtendedDialog showDialog() {
        ExtendedDialog result = super.showDialog();
        if (this.getValue() == 1) {
            try {
                this.settings.epsilonMult = NumberFormat.getInstance().parse(this.text1.getText()).doubleValue();
                this.settings.startingEps = NumberFormat.getInstance().parse(this.text2.getText()).doubleValue();
                this.settings.maxPointsPerKm = NumberFormat.getInstance().parse(this.text3.getText()).doubleValue();
                this.settings.snapNodes = this.snapCb.isSelected();
                this.settings.fixedClick = this.fixedClickCb.isSelected();
                this.settings.fixedSpacebar = this.fixedSpaceCb.isSelected();
                this.settings.allowEditExistingWays = this.allowEditExistingWaysCb.isSelected();
                this.settings.drawClosed = this.drawClosedCb.isSelected();
                this.settings.simplifyMode = this.combo1.getSelectedIndex();
                this.settings.autoTags = this.addTags.getText();
                if (!this.settings.autoTags.isEmpty()) {
                    this.addTags.addCurrentItemToHistory();
                }
                Main.pref.putCollection("fastdraw.tags-history", (Collection)this.addTags.getHistory());
                this.settings.savePrefs();
            }
            catch (ParseException e) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Can not read settings", (Object[])new Object[0]));
            }
        }
        return result;
    }
}

