/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LinearComponentExtracter
implements GeometryComponentFilter {
    private Collection lines;
    private boolean isForcedToLineString = false;

    public static Collection getLines(Collection geoms, Collection lines) {
        for (Geometry g : geoms) {
            LinearComponentExtracter.getLines(g, lines);
        }
        return lines;
    }

    public static Collection getLines(Collection geoms, Collection lines, boolean forceToLineString) {
        for (Geometry g : geoms) {
            LinearComponentExtracter.getLines(g, lines, forceToLineString);
        }
        return lines;
    }

    public static Collection getLines(Geometry geom, Collection lines) {
        if (geom instanceof LineString) {
            lines.add(geom);
        } else {
            geom.apply(new LinearComponentExtracter(lines));
        }
        return lines;
    }

    public static Collection getLines(Geometry geom, Collection lines, boolean forceToLineString) {
        geom.apply(new LinearComponentExtracter(lines, forceToLineString));
        return lines;
    }

    public static List getLines(Geometry geom) {
        return LinearComponentExtracter.getLines(geom, false);
    }

    public static List getLines(Geometry geom, boolean forceToLineString) {
        ArrayList lines = new ArrayList();
        geom.apply(new LinearComponentExtracter(lines, forceToLineString));
        return lines;
    }

    public LinearComponentExtracter(Collection lines) {
        this.lines = lines;
    }

    public LinearComponentExtracter(Collection lines, boolean isForcedToLineString) {
        this.lines = lines;
        this.isForcedToLineString = isForcedToLineString;
    }

    public void setForceToLineString(boolean isForcedToLineString) {
        this.isForcedToLineString = isForcedToLineString;
    }

    public void filter(Geometry geom) {
        if (this.isForcedToLineString && geom instanceof LinearRing) {
            LineString line = geom.getFactory().createLineString(((LinearRing)geom).getCoordinateSequence());
            this.lines.add(line);
            return;
        }
        if (geom instanceof LineString) {
            this.lines.add(geom);
        }
    }
}

