/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.search;

import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.NodeWayUtils;

public class ConnectedMatch
extends SearchCompiler.UnaryMatch {
    private Collection<Way> connected = null;
    boolean all;

    public ConnectedMatch(SearchCompiler.Match match, boolean all) {
        super(match);
        this.all = all;
    }

    private void init(boolean all) {
        HashSet<Way> matchedWays = new HashSet<Way>();
        HashSet<Node> matchedNodes = new HashSet<Node>();
        Collection allWays = Main.getLayerManager().getEditDataSet().getWays();
        for (Object way : allWays) {
            if (!this.match.match((OsmPrimitive)way)) continue;
            matchedWays.add((Way)way);
        }
        Collection allNodes = Main.getLayerManager().getEditDataSet().getNodes();
        for (Node node : allNodes) {
            if (!this.match.match((OsmPrimitive)node)) continue;
            matchedNodes.add(node);
        }
        HashSet<Way> newWays = new HashSet<Way>();
        if (all) {
            NodeWayUtils.addWaysConnectedToNodes(matchedNodes, newWays);
            NodeWayUtils.addWaysConnectedToWaysRecursively(matchedWays, newWays);
        } else {
            NodeWayUtils.addWaysConnectedToNodes(matchedNodes, newWays);
            NodeWayUtils.addWaysConnectedToWays(matchedWays, newWays);
        }
        this.connected = newWays;
    }

    public boolean match(OsmPrimitive osm) {
        if (this.connected == null) {
            this.init(this.all);
        }
        if (osm instanceof Way) {
            return this.connected.contains(osm);
        }
        return false;
    }
}

