/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.OSMStreet;
import org.openstreetmap.josm.tools.I18n;

public class AddressEditModel {
    private List<OSMStreet> streets;
    private List<OSMAddress> unresolvedAddresses;
    private List<OSMAddress> incompleteAddresses = new ArrayList<OSMAddress>();
    private DefaultMutableTreeNode streetRoot;
    private DefaultMutableTreeNode unresolvedRoot;
    private DefaultMutableTreeNode incompleteRoot;

    public AddressEditModel(List<OSMStreet> streets, List<OSMAddress> unresolvedAddresses) {
        this.streets = streets;
        this.unresolvedAddresses = unresolvedAddresses;
    }

    public TreeNode getStreetsTree() {
        if (this.streets == null) {
            return new DefaultMutableTreeNode(I18n.tr((String)"(No data)", (Object[])new Object[0]));
        }
        if (this.streetRoot == null) {
            this.streetRoot = new DefaultMutableTreeNode();
            for (OSMStreet sNode : this.streets) {
                DefaultMutableTreeNode treeStreetNode = new DefaultMutableTreeNode(sNode);
                DefaultMutableTreeNode segmentsNode = new DefaultMutableTreeNode(I18n.tr((String)"Segments", (Object[])new Object[0]));
                treeStreetNode.add(segmentsNode);
                for (IOSMEntity child : sNode.getChildren()) {
                    segmentsNode.add(new DefaultMutableTreeNode(child));
                }
                if (sNode.hasAddresses()) {
                    DefaultMutableTreeNode addressNode = new DefaultMutableTreeNode(I18n.tr((String)"Addresses", (Object[])new Object[0]));
                    treeStreetNode.add(addressNode);
                    for (OSMAddress addr : sNode.getAddresses()) {
                        addressNode.add(new DefaultMutableTreeNode(addr));
                        if (addr.isComplete()) continue;
                        this.incompleteAddresses.add(addr);
                    }
                }
                this.streetRoot.add(treeStreetNode);
            }
        }
        return this.streetRoot;
    }

    public TreeNode getUnresolvedAddressesTree() {
        if (this.unresolvedAddresses == null) {
            return new DefaultMutableTreeNode(I18n.tr((String)"(No data)", (Object[])new Object[0]));
        }
        if (this.unresolvedRoot == null) {
            this.unresolvedRoot = new DefaultMutableTreeNode();
            for (OSMAddress addr : this.unresolvedAddresses) {
                this.unresolvedRoot.add(new DefaultMutableTreeNode(addr));
            }
        }
        return this.unresolvedRoot;
    }

    public TreeNode getIncompleteAddressesTree() {
        if (this.incompleteAddresses == null) {
            return new DefaultMutableTreeNode(I18n.tr((String)"(No data)", (Object[])new Object[0]));
        }
        if (this.incompleteRoot == null) {
            this.incompleteRoot = new DefaultMutableTreeNode();
            for (OSMAddress addr : this.incompleteAddresses) {
                this.incompleteRoot.add(new DefaultMutableTreeNode(addr));
            }
        }
        return this.incompleteRoot;
    }
}

