/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.plugins.graphview.core.transition.Restriction;
import org.openstreetmap.josm.plugins.graphview.core.transition.Segment;
import org.openstreetmap.josm.plugins.graphview.core.transition.SegmentNode;

abstract class EvaluationGroup {
    protected boolean evaluated = false;
    protected List<Segment>[][] segmentSequences;
    private static final List<Segment> EMPTY_SEGMENT_LIST = Collections.unmodifiableList(new ArrayList(0));
    private static final List<Restriction> EMPTY_RESTRICTION_LIST = Collections.unmodifiableList(new ArrayList(0));

    EvaluationGroup() {
    }

    protected List<Segment> findSegmentSequence(SegmentNode firstNode, SegmentNode lastNode, Collection<Restriction> restrictions) {
        return this.findSegmentSequence(firstNode, lastNode, restrictions, EMPTY_RESTRICTION_LIST, EMPTY_RESTRICTION_LIST);
    }

    protected List<Segment> findSegmentSequence(Segment firstSegment, Segment lastSegment, Collection<Restriction> restrictions) {
        if (firstSegment == lastSegment) {
            return EMPTY_SEGMENT_LIST;
        }
        Collection<Restriction> initiallyActiveRestrictions = EvaluationGroup.activeRestrictionsAfterSegment(firstSegment, EMPTY_RESTRICTION_LIST, restrictions);
        HashSet<Restriction> restrictionsForbiddenAtLastNode = new HashSet<Restriction>();
        for (Restriction restriction : restrictions) {
            if (!restriction.getTos().contains(lastSegment)) continue;
            restrictionsForbiddenAtLastNode.add(restriction);
        }
        return this.findSegmentSequence(firstSegment.getNode2(), lastSegment.getNode1(), restrictions, initiallyActiveRestrictions, restrictionsForbiddenAtLastNode);
    }

    private List<Segment> findSegmentSequence(SegmentNode firstNode, SegmentNode lastNode, Collection<Restriction> restrictions, Collection<Restriction> initiallyActiveRestrictions, Collection<Restriction> restrictionsForbiddenAtLastNode) {
        if (firstNode == lastNode && !EvaluationGroup.shareElement(initiallyActiveRestrictions, restrictionsForbiddenAtLastNode)) {
            return EMPTY_SEGMENT_LIST;
        }
        LinkedList<State> stateQueue = new LinkedList<State>();
        stateQueue.add(EvaluationGroup.createStartingState(firstNode, initiallyActiveRestrictions));
        while (stateQueue.size() > 0) {
            State state = (State)stateQueue.poll();
            List<State> subsequentStates = this.createSubsequentStates(state, restrictions);
            for (State subsequentState : subsequentStates) {
                if (subsequentState.currentNode != lastNode || EvaluationGroup.shareElement(subsequentState.activeRestrictions, restrictionsForbiddenAtLastNode)) continue;
                return subsequentState.segmentHistory;
            }
            stateQueue.addAll(subsequentStates);
        }
        return null;
    }

    private static State createStartingState(SegmentNode firstNode, Collection<Restriction> initiallyActiveRestrictions) {
        State startingState = new State();
        startingState.currentNode = firstNode;
        startingState.activeRestrictions = initiallyActiveRestrictions;
        startingState.segmentHistory = EMPTY_SEGMENT_LIST;
        startingState.visitedNodes = new HashSet<SegmentNode>();
        startingState.visitedNodes.add(firstNode);
        return startingState;
    }

    private List<State> createSubsequentStates(State state, Collection<Restriction> allRestrictions) {
        ArrayList<State> subsequentStates = new ArrayList<State>();
        for (Segment segment : state.currentNode.getOutboundSegments()) {
            if (!this.isUsableSegment(segment) || !EvaluationGroup.isLegalSegment(segment, state.activeRestrictions)) continue;
            State newState = new State();
            newState.activeRestrictions = EvaluationGroup.activeRestrictionsAfterSegment(segment, state.activeRestrictions, allRestrictions);
            newState.segmentHistory = new ArrayList<Segment>(state.segmentHistory.size() + 1);
            newState.segmentHistory.addAll(state.segmentHistory);
            newState.segmentHistory.add(segment);
            newState.currentNode = segment.getNode2();
            newState.visitedNodes = new HashSet<SegmentNode>(state.visitedNodes);
            newState.visitedNodes.add(newState.currentNode);
            if (state.visitedNodes.contains(newState.currentNode) || !this.isUsableNode(newState.currentNode)) continue;
            subsequentStates.add(newState);
        }
        return subsequentStates;
    }

    private static List<Restriction> getRestrictionsStartedBySegment(Collection<Restriction> restrictions, Segment segment) {
        List<Restriction> result = EMPTY_RESTRICTION_LIST;
        for (Restriction restriction : restrictions) {
            if (restriction.getFrom() != segment) continue;
            if (result == EMPTY_RESTRICTION_LIST) {
                result = new ArrayList<Restriction>(restrictions.size());
            }
            result.add(restriction);
        }
        return result;
    }

    private static Collection<Restriction> activeRestrictionsAfterSegment(Segment segment, Collection<Restriction> activeRestrictionsBeforeSegment, Collection<Restriction> allRestrictions) {
        List<Restriction> result = EMPTY_RESTRICTION_LIST;
        for (Restriction restriction : activeRestrictionsBeforeSegment) {
            if (!restriction.getVias().contains(segment)) continue;
            if (result == EMPTY_RESTRICTION_LIST) {
                result = new ArrayList<Restriction>(allRestrictions.size());
            }
            result.add(restriction);
        }
        List<Restriction> newRestrictions = EvaluationGroup.getRestrictionsStartedBySegment(allRestrictions, segment);
        if (newRestrictions.size() > 0) {
            if (result == EMPTY_RESTRICTION_LIST) {
                result = newRestrictions;
            } else {
                result.addAll(newRestrictions);
            }
        }
        return result;
    }

    private static boolean isLegalSegment(Segment segment, Collection<Restriction> activeRestrictions) {
        for (Restriction restriction : activeRestrictions) {
            if (!restriction.getTos().contains(segment)) continue;
            return false;
        }
        return true;
    }

    protected static boolean shareElement(Collection<?> collection1, Collection<?> collection2) {
        for (Object element : collection1) {
            if (!collection2.contains(element)) continue;
            return true;
        }
        return false;
    }

    public final void evaluate(Collection<Restriction> restrictions) {
        if (this.evaluated) {
            return;
        }
        this.evaluateImpl(restrictions);
        this.evaluated = true;
    }

    protected abstract void evaluateImpl(Collection<Restriction> var1);

    protected abstract boolean isUsableNode(SegmentNode var1);

    protected abstract boolean isUsableSegment(Segment var1);

    private static class State {
        SegmentNode currentNode;
        Set<SegmentNode> visitedNodes;
        Collection<Restriction> activeRestrictions;
        List<Segment> segmentHistory;

        private State() {
        }
    }
}

