/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.modules;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.sources.SourceProvider;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.plugins.opendata.OdPlugin;
import org.openstreetmap.josm.plugins.opendata.core.gui.OdPreferenceSetting;
import org.openstreetmap.josm.plugins.opendata.core.modules.Module;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleDownloadTask;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleException;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleInformation;
import org.openstreetmap.josm.plugins.opendata.core.modules.ReadLocalModuleInformationTask;
import org.openstreetmap.josm.plugins.opendata.core.modules.ReadRemoteModuleInformationTask;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public final class ModuleHandler {
    public static final Collection<Module> moduleList = new LinkedList<Module>();
    private static final List<ClassLoader> sources = new LinkedList<ClassLoader>();

    private ModuleHandler() {
    }

    public static Collection<ClassLoader> getResourceClassLoaders() {
        return Collections.unmodifiableCollection(sources);
    }

    public static boolean checkAndConfirmModuleUpdate(Component parent) {
        String message = null;
        String togglePreferenceKey = null;
        long tim = System.currentTimeMillis();
        long last = Main.pref.getLong("opendata.modulemanager.lastupdate", 0L);
        Integer maxTime = Main.pref.getInteger("opendata.modulemanager.time-based-update.interval", 60);
        long d = (tim - last) / 86400000L;
        if (last <= 0L || maxTime <= 0) {
            Main.pref.put("opendata.modulemanager.lastupdate", Long.toString(tim));
        } else if (d > (long)maxTime.intValue()) {
            message = "<html>" + I18n.tr((String)"Last module update more than {0} days ago.", (Object[])new Object[]{d}) + "</html>";
            togglePreferenceKey = "opendata.modulemanager.time-based-update.policy";
        }
        if (message == null) {
            return false;
        }
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Update modules", (Object[])new Object[0]), (Icon)ImageProvider.get((String)"dialogs", (String)"refresh"), I18n.tr((String)"Click to update the activated modules", (Object[])new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Skip update", (Object[])new Object[0]), (Icon)ImageProvider.get((String)"cancel"), I18n.tr((String)"Click to skip updating the activated modules", (Object[])new Object[0]), null)};
        UpdateModulesMessagePanel pnlMessage = new UpdateModulesMessagePanel();
        pnlMessage.setMessage(message);
        pnlMessage.initDontShowAgain(togglePreferenceKey);
        String policy = Main.pref.get(togglePreferenceKey, "ask");
        policy = policy.trim().toLowerCase();
        if (policy.equals("never")) {
            if ("opendata.modulemanager.time-based-update.policy".equals(togglePreferenceKey)) {
                Logging.info((String)I18n.tr((String)"Skipping module update after elapsed update interval. Automatic update at startup is disabled.", (Object[])new Object[0]));
            }
            return false;
        }
        if (policy.equals("always")) {
            if ("opendata.modulemanager.time-based-update.policy".equals(togglePreferenceKey)) {
                Logging.info((String)I18n.tr((String)"Running module update after elapsed update interval. Automatic update at startup is disabled.", (Object[])new Object[0]));
            }
            return true;
        }
        if (!policy.equals("ask")) {
            Logging.warn((String)I18n.tr((String)"Unexpected value ''{0}'' for preference ''{1}''. Assuming value ''ask''.", (Object[])new Object[]{policy, togglePreferenceKey}));
        }
        int ret = HelpAwareOptionPane.showOptionDialog((Component)parent, (Object)pnlMessage, (String)I18n.tr((String)"Update modules", (Object[])new Object[0]), (int)2, null, (HelpAwareOptionPane.ButtonSpec[])options, (HelpAwareOptionPane.ButtonSpec)options[0], null);
        if (pnlMessage.isRememberDecision()) {
            switch (ret) {
                case 0: {
                    Main.pref.put(togglePreferenceKey, "always");
                    break;
                }
                case -1: 
                case 1: {
                    Main.pref.put(togglePreferenceKey, "never");
                }
            }
        } else {
            Main.pref.put(togglePreferenceKey, "ask");
        }
        return ret == 0;
    }

    public static boolean checkLoadPreconditions(Component parent, Collection<ModuleInformation> modules, ModuleInformation module) {
        return true;
    }

    public static ClassLoader createClassLoader(Collection<ModuleInformation> modules) {
        LinkedList<URL> allModuleLibraries = new LinkedList<URL>();
        File moduleDir = OdPlugin.getInstance().getModulesDirectory();
        for (ModuleInformation info : modules) {
            if (info.libraries == null) continue;
            allModuleLibraries.addAll(info.libraries);
            File moduleJar = new File(moduleDir, info.name + ".jar");
            I18n.addTexts((File)moduleJar);
            URL moduleJarUrl = ModuleInformation.fileToURL(moduleJar);
            allModuleLibraries.add(moduleJarUrl);
        }
        return new URLClassLoader(allModuleLibraries.toArray(new URL[0]), OdPlugin.class.getClassLoader());
    }

    public static void loadModule(Component parent, ModuleInformation module, ClassLoader moduleClassLoader) {
        String msg = I18n.tr((String)"Could not load module {0}. Delete from preferences?", (Object[])new Object[]{module.name});
        try {
            Class<? extends Module> klass = module.loadClass(moduleClassLoader);
            if (klass != null) {
                Logging.info((String)I18n.tr((String)"loading module ''{0}'' (version {1})", (Object[])new Object[]{module.name, module.localversion}));
                Module mod = module.load(klass);
                if (moduleList.add(mod)) {
                    SourceProvider presetProvider;
                    SourceProvider styleProvider = mod.getMapPaintStyleSourceProvider();
                    if (styleProvider != null) {
                        MapPaintPreference.registerSourceProvider((SourceProvider)styleProvider);
                    }
                    if ((presetProvider = mod.getPresetSourceProvider()) != null) {
                        TaggingPresetPreference.registerSourceProvider((SourceProvider)presetProvider);
                    }
                }
            }
            msg = null;
        }
        catch (ModuleException e) {
            e.printStackTrace();
            if (e.getCause() instanceof ClassNotFoundException) {
                msg = I18n.tr((String)"<html>Could not load module {0} because the module<br>main class ''{1}'' was not found.<br>Delete from preferences?</html>", (Object[])new Object[]{module.name, module.className});
            }
        }
        catch (Exception e) {
            Logging.error((Throwable)e);
        }
        if (msg != null && ModuleHandler.confirmDisableModule(parent, msg, module.name)) {
            Main.pref.removeFromCollection("opendata.modules", module.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadModules(Component parent, Collection<ModuleInformation> modules, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask(I18n.tr((String)"Loading modules ...", (Object[])new Object[0]));
            monitor.subTask(I18n.tr((String)"Checking module preconditions...", (Object[])new Object[0]));
            LinkedList<ModuleInformation> toLoad = new LinkedList<ModuleInformation>();
            for (ModuleInformation pi : modules) {
                if (!ModuleHandler.checkLoadPreconditions(parent, modules, pi)) continue;
                toLoad.add(pi);
            }
            if (toLoad.isEmpty()) {
                return;
            }
            ClassLoader moduleClassLoader = ModuleHandler.createClassLoader(toLoad);
            sources.add(0, moduleClassLoader);
            monitor.setTicksCount(toLoad.size());
            for (ModuleInformation info : toLoad) {
                monitor.setExtraText(I18n.tr((String)"Loading module ''{0}''...", (Object[])new Object[]{info.name}));
                ModuleHandler.loadModule(parent, info, moduleClassLoader);
                monitor.worked(1);
            }
        }
        finally {
            monitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, ModuleInformation> loadLocallyAvailableModuleInformation(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            ReadLocalModuleInformationTask task = new ReadLocalModuleInformationTask(monitor);
            ExecutorService service = Executors.newSingleThreadExecutor();
            Future<?> future = service.submit((Runnable)((Object)task));
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Logging.error((Throwable)e);
                Map<String, ModuleInformation> map = null;
                monitor.finishTask();
                return map;
            }
            HashMap<String, ModuleInformation> ret = new HashMap<String, ModuleInformation>();
            for (ModuleInformation pi : task.getAvailableModules()) {
                ret.put(pi.name, pi);
            }
            HashMap<String, ModuleInformation> hashMap = ret;
            return hashMap;
        }
        finally {
            monitor.finishTask();
        }
    }

    private static void alertMissingModuleInformation(Component parent, Collection<String> modules) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(I18n.trn((String)"JOSM could not find information about the following module:", (String)"JOSM could not find information about the following modules:", (long)modules.size(), (Object[])new Object[0]));
        sb.append("<ul>");
        for (String module : modules) {
            sb.append("<li>").append(module).append("</li>");
        }
        sb.append("</ul>");
        sb.append(I18n.trn((String)"The module is not going to be loaded.", (String)"The modules are not going to be loaded.", (long)modules.size(), (Object[])new Object[0]));
        sb.append("</html>");
        HelpAwareOptionPane.showOptionDialog((Component)parent, (Object)sb.toString(), (String)I18n.tr((String)"Warning", (Object[])new Object[0]), (int)2, (String)HelpUtil.ht((String)"/Module/Loading#MissingModuleInfos"));
    }

    public static List<ModuleInformation> buildListOfModulesToLoad(Component parent) {
        HashSet<String> modules = new HashSet<String>();
        modules.addAll(Main.pref.getCollection("opendata.modules", new LinkedList()));
        if (System.getProperty("josm.opendata.modules") != null) {
            modules.addAll(Arrays.asList(System.getProperty("josm.opendata.modules").split(",")));
        }
        Map<String, ModuleInformation> infos = ModuleHandler.loadLocallyAvailableModuleInformation(null);
        LinkedList<ModuleInformation> ret = new LinkedList<ModuleInformation>();
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            String module = (String)it.next();
            if (!infos.containsKey(module)) continue;
            ret.add(infos.get(module));
            it.remove();
        }
        if (!modules.isEmpty()) {
            ModuleHandler.alertMissingModuleInformation(parent, modules);
        }
        return ret;
    }

    private static void alertFailedModuleUpdate(Component parent, Collection<ModuleInformation> modules) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append(I18n.trn((String)"Updating the following module has failed:", (String)"Updating the following modules has failed:", (long)modules.size(), (Object[])new Object[0]));
        sb.append("<ul>");
        for (ModuleInformation pi : modules) {
            sb.append("<li>").append(pi.name).append("</li>");
        }
        sb.append("</ul>");
        sb.append(I18n.trn((String)"Please open the Preference Dialog after JOSM has started and try to update it manually.", (String)"Please open the Preference Dialog after JOSM has started and try to update them manually.", (long)modules.size(), (Object[])new Object[0]));
        sb.append("</html>");
        HelpAwareOptionPane.showOptionDialog((Component)parent, (Object)sb.toString(), (String)I18n.tr((String)"Module update failed", (Object[])new Object[0]), (int)0, (String)HelpUtil.ht((String)"/Module/Loading#FailedModuleUpdated"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List<ModuleInformation> updateModules(Component parent, List<ModuleInformation> modules, ProgressMonitor monitor) throws IllegalArgumentException {
        block14: {
            CheckParameterUtil.ensureParameterNotNull(modules, (String)"modules");
            if (monitor == null) {
                monitor = NullProgressMonitor.INSTANCE;
            }
            try {
                monitor.beginTask("");
                ExecutorService service = Executors.newSingleThreadExecutor();
                ReadRemoteModuleInformationTask task1 = new ReadRemoteModuleInformationTask(monitor.createSubTaskMonitor(1, false), OdPreferenceSetting.getModuleSites());
                Future<?> future = service.submit((Runnable)((Object)task1));
                try {
                    future.get();
                    modules = ModuleHandler.buildListOfModulesToLoad(parent);
                }
                catch (ExecutionException e) {
                    Logging.warn((String)I18n.tr((String)"Warning: failed to download module information list", (Object[])new Object[0]));
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    Logging.warn((String)I18n.tr((String)"Warning: failed to download module information list", (Object[])new Object[0]));
                    e.printStackTrace();
                }
                ArrayList<ModuleInformation> modulesToUpdate = new ArrayList<ModuleInformation>();
                for (ModuleInformation pi : modules) {
                    if (!pi.isUpdateRequired()) continue;
                    modulesToUpdate.add(pi);
                }
                if (modulesToUpdate.isEmpty()) break block14;
                ModuleDownloadTask task2 = new ModuleDownloadTask(monitor.createSubTaskMonitor(1, false), modulesToUpdate, I18n.tr((String)"Update modules", (Object[])new Object[0]));
                future = service.submit((Runnable)((Object)task2));
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    ModuleHandler.alertFailedModuleUpdate(parent, modulesToUpdate);
                    List<ModuleInformation> list = modules;
                    monitor.finishTask();
                    return list;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    ModuleHandler.alertFailedModuleUpdate(parent, modulesToUpdate);
                    List<ModuleInformation> list = modules;
                    monitor.finishTask();
                    return list;
                }
                if (!task2.getFailedModules().isEmpty()) {
                    ModuleHandler.alertFailedModuleUpdate(parent, task2.getFailedModules());
                    List<ModuleInformation> list = modules;
                    return list;
                }
                break block14;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                monitor.finishTask();
            }
        }
        Main.pref.put("opendata.modulemanager.lastupdate", Long.toString(System.currentTimeMillis()));
        return modules;
    }

    public static boolean confirmDisableModule(Component parent, String reason, String name) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Disable module", (Object[])new Object[0]), (Icon)ImageProvider.get((String)"dialogs", (String)"delete"), I18n.tr((String)"Click to delete the module ''{0}''", (Object[])new Object[]{name}), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Keep module", (Object[])new Object[0]), (Icon)ImageProvider.get((String)"cancel"), I18n.tr((String)"Click to keep the module ''{0}''", (Object[])new Object[]{name}), null)};
        int ret = HelpAwareOptionPane.showOptionDialog((Component)parent, (Object)reason, (String)I18n.tr((String)"Disable module", (Object[])new Object[0]), (int)2, null, (HelpAwareOptionPane.ButtonSpec[])options, (HelpAwareOptionPane.ButtonSpec)options[0], null);
        return ret == 0;
    }

    public static void installDownloadedModules(boolean dowarn) {
        File[] files;
        File moduleDir = OdPlugin.getInstance().getModulesDirectory();
        if (!(moduleDir.exists() && moduleDir.isDirectory() && moduleDir.canWrite())) {
            return;
        }
        for (File updatedModule : files = moduleDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar.new");
            }
        })) {
            String filePath = updatedModule.getPath();
            File module = new File(filePath.substring(0, filePath.length() - 4));
            String moduleName = updatedModule.getName().substring(0, updatedModule.getName().length() - 8);
            if (module.exists() && !module.delete() && dowarn) {
                Logging.warn((String)I18n.tr((String)"Warning: failed to delete outdated module ''{0}''.", (Object[])new Object[]{module.toString()}));
                Logging.warn((String)I18n.tr((String)"Warning: failed to install already downloaded module ''{0}''. Skipping installation. JOSM is still going to load the old module version.", (Object[])new Object[]{moduleName}));
                continue;
            }
            if (updatedModule.renameTo(module) || !dowarn) continue;
            Logging.warn((String)I18n.tr((String)"Warning: failed to install module ''{0}'' from temporary download file ''{1}''. Renaming failed.", (Object[])new Object[]{module.toString(), updatedModule.toString()}));
            Logging.warn((String)I18n.tr((String)"Warning: failed to install already downloaded module ''{0}''. Skipping installation. JOSM is still going to load the old module version.", (Object[])new Object[]{moduleName}));
        }
    }

    static {
        try {
            sources.add(ClassLoader.getSystemClassLoader());
            sources.add(MainApplication.class.getClassLoader());
        }
        catch (SecurityException ex) {
            sources.add(ImageProvider.class.getClassLoader());
        }
    }

    private static class UpdateModulesMessagePanel
    extends JPanel {
        private JMultilineLabel lblMessage;
        private JCheckBox cbDontShowAgain;

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.insets = new Insets(5, 5, 5, 5);
            this.lblMessage = new JMultilineLabel("");
            this.add((Component)this.lblMessage, gc);
            this.lblMessage.setFont(this.lblMessage.getFont().deriveFont(0));
            gc.gridy = 1;
            gc.fill = 2;
            gc.weighty = 0.0;
            this.cbDontShowAgain = new JCheckBox(I18n.tr((String)"Do not ask again and remember my decision (go to Preferences->Modules to change it later)", (Object[])new Object[0]));
            this.add((Component)this.cbDontShowAgain, gc);
            this.cbDontShowAgain.setFont(this.cbDontShowAgain.getFont().deriveFont(0));
        }

        UpdateModulesMessagePanel() {
            this.build();
        }

        public void setMessage(String message) {
            this.lblMessage.setText(message);
        }

        public void initDontShowAgain(String preferencesKey) {
            String policy = Main.pref.get(preferencesKey, "ask");
            this.cbDontShowAgain.setSelected(!(policy = policy.trim().toLowerCase()).equals("ask"));
        }

        public boolean isRememberDecision() {
            return this.cbDontShowAgain.isSelected();
        }
    }
}

