/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.util.ModifiableInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeighborIndex<V, E>
implements GraphListener<V, E> {
    Map<V, Neighbors<V, E>> neighborMap = new HashMap<V, Neighbors<V, E>>();
    private Graph<V, E> graph;

    public NeighborIndex(Graph<V, E> graph) {
        this.graph = graph;
    }

    public Set<V> neighborsOf(V v) {
        return this.getNeighbors(v).getNeighbors();
    }

    public List<V> neighborListOf(V v) {
        return this.getNeighbors(v).getNeighborList();
    }

    @Override
    public void edgeAdded(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
        E e = graphEdgeChangeEvent.getEdge();
        V v = this.graph.getEdgeSource(e);
        V v2 = this.graph.getEdgeTarget(e);
        this.getNeighbors(v).addNeighbor(v2);
        this.getNeighbors(v2).addNeighbor(v);
    }

    @Override
    public void edgeRemoved(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
        E e = graphEdgeChangeEvent.getEdge();
        V v = this.graph.getEdgeSource(e);
        V v2 = this.graph.getEdgeTarget(e);
        if (this.neighborMap.containsKey(v)) {
            this.neighborMap.get(v).removeNeighbor(v2);
        }
        if (this.neighborMap.containsKey(v2)) {
            this.neighborMap.get(v2).removeNeighbor(v);
        }
    }

    @Override
    public void vertexAdded(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
    }

    @Override
    public void vertexRemoved(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
        this.neighborMap.remove(graphVertexChangeEvent.getVertex());
    }

    private Neighbors<V, E> getNeighbors(V v) {
        Neighbors<V, E> neighbors = this.neighborMap.get(v);
        if (neighbors == null) {
            neighbors = new Neighbors(v, Graphs.neighborListOf(this.graph, v));
            this.neighborMap.put((Neighbors<V, E>)v, (Neighbors<Neighbors<V, E>, E>)neighbors);
        }
        return neighbors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Neighbors<V, E> {
        private Map<V, ModifiableInteger> neighborCounts = new LinkedHashMap<V, ModifiableInteger>();
        private Set<V> neighborSet = Collections.unmodifiableSet(this.neighborCounts.keySet());

        public Neighbors(V v, Collection<V> collection) {
            for (V v2 : collection) {
                this.addNeighbor(v2);
            }
        }

        public void addNeighbor(V v) {
            ModifiableInteger modifiableInteger = this.neighborCounts.get(v);
            if (modifiableInteger == null) {
                modifiableInteger = new ModifiableInteger(1);
                this.neighborCounts.put((ModifiableInteger)v, modifiableInteger);
            } else {
                modifiableInteger.increment();
            }
        }

        public void removeNeighbor(V v) {
            ModifiableInteger modifiableInteger = this.neighborCounts.get(v);
            if (modifiableInteger == null) {
                throw new IllegalArgumentException("Attempting to remove a neighbor that wasn't present");
            }
            modifiableInteger.decrement();
            if (modifiableInteger.getValue() == 0) {
                this.neighborCounts.remove(v);
            }
        }

        public Set<V> getNeighbors() {
            return this.neighborSet;
        }

        public List<V> getNeighborList() {
            ArrayList<V> arrayList = new ArrayList<V>();
            for (Map.Entry<V, ModifiableInteger> entry : this.neighborCounts.entrySet()) {
                V v = entry.getKey();
                int n = entry.getValue().intValue();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(v);
                }
            }
            return arrayList;
        }
    }
}

