/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing.actions;

import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.RoutingPlugin;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AddRouteNodeAction
extends MapMode {
    static Logger logger = Logger.getLogger(AddRouteNodeAction.class);

    public AddRouteNodeAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Routing", (Object[])new Object[0]), "add", I18n.tr((String)"Click to add destination.", (Object[])new Object[0]), mapFrame, ImageProvider.getCursor((String)"crosshair", null));
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            Node node = null;
            if (Main.getLayerManager().getActiveLayer() instanceof RoutingLayer) {
                RoutingLayer layer = (RoutingLayer)Main.getLayerManager().getActiveLayer();
                node = layer.getNearestHighwayNode(e.getPoint());
                if (node == null) {
                    logger.debug((Object)"no selected node");
                    return;
                }
                logger.debug((Object)("selected node " + node));
                layer.getRoutingModel().addNode(node);
                RoutingPlugin.getInstance().getRoutingDialog().addNode(node);
            }
        }
        Main.map.repaint();
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof RoutingLayer;
    }
}

