/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.service.value;

public class BoundingBox {
    private Double minLon;
    private Double minLat;
    private Double maxLon;
    private Double maxLat;

    public BoundingBox() {
    }

    public BoundingBox(Double minLon, Double minLat, Double maxLon, Double maxLat) {
        this.minLon = minLon;
        this.minLat = minLat;
        this.maxLon = maxLon;
        this.maxLat = maxLat;
        this.normalize();
    }

    private void normalize() {
        if (this.minLon < -180.0) {
            this.minLon = -180.0;
        }
        if (this.maxLon > 180.0) {
            this.maxLon = 180.0;
        }
        if (this.minLat < -90.0) {
            this.minLat = -90.0;
        }
        if (this.maxLat > 90.0) {
            this.maxLat = 90.0;
        }
    }

    public Double getMinLon() {
        return this.minLon;
    }

    public Double getMinLat() {
        return this.minLat;
    }

    public Double getMaxLon() {
        return this.maxLon;
    }

    public Double getMaxLat() {
        return this.maxLat;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.maxLat == null ? 0 : this.maxLat.hashCode());
        result = 31 * result + (this.maxLon == null ? 0 : this.maxLon.hashCode());
        result = 31 * result + (this.minLat == null ? 0 : this.minLat.hashCode());
        result = 31 * result + (this.minLon == null ? 0 : this.minLon.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BoundingBox) {
            BoundingBox bBox = (BoundingBox)obj;
            Double bBoxMinLon = bBox.getMinLon();
            Double bBoxMinLat = bBox.getMinLat();
            Double bBoxMaxLon = bBox.getMaxLon();
            Double bBoxMaxLat = bBox.getMaxLat();
            return this.minLon.equals(bBoxMinLon) && this.minLat.equals(bBoxMinLat) && this.maxLon.equals(bBoxMaxLon) && this.maxLat.equals(bBoxMaxLat);
        }
        return false;
    }
}

