/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.action.execute;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustActionUploader;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustActionUploaderException;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustGUI;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.MapdustExecuteActionObservable;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustPluginState;
import org.openstreetmap.josm.tools.I18n;

public class ExecuteWorkOffline
extends MapdustExecuteActionObservable {
    private static final long serialVersionUID = 8792828131813689548L;

    public ExecuteWorkOffline() {
    }

    public ExecuteWorkOffline(MapdustGUI mapdustGUI) {
        this.setMapdustGUI(mapdustGUI);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof JToggleButton) {
            JToggleButton btn = (JToggleButton)event.getSource();
            if (this.getMapdustGUI() != null) {
                String pluginState = Main.pref.get("mapdust.pluginState");
                if (pluginState.equals(MapdustPluginState.ONLINE.getValue())) {
                    Main.pref.put("mapdust.pluginState", MapdustPluginState.OFFLINE.getValue());
                    btn.setSelected(false);
                    btn.setFocusable(false);
                } else {
                    String title = "MapDust";
                    String message = "Do you want to submit your changes ";
                    int result = JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)(message = message + "to Mapdust?"), (Object[])new Object[0]), I18n.tr((String)title, (Object[])new Object[0]), 0);
                    if (result == 0) {
                        try {
                            MapdustActionUploader.getInstance().uploadData(this.getMapdustGUI().getMapdustActionList());
                        }
                        catch (MapdustActionUploaderException e) {
                            String errorMessage = "There was a Mapdust service";
                            errorMessage = errorMessage + " error.";
                            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)errorMessage, (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
                        }
                    }
                    Main.pref.put("mapdust.pluginState", MapdustPluginState.ONLINE.getValue());
                    btn.setSelected(false);
                    btn.setFocusable(false);
                }
                this.notifyObservers(null, false);
            }
        }
    }
}

