/*
 * Decompiled with CFR 0.152.
 */
package org.insignificant.josm.plugins.imagewaypoint;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import org.insignificant.josm.plugins.imagewaypoint.IImageChangeListener;
import org.insignificant.josm.plugins.imagewaypoint.ImageEntries;
import org.insignificant.josm.plugins.imagewaypoint.ImageEntry;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public final class ImageWayPointLayer
extends Layer {
    private final MouseListener layerMouseListener;
    private final IImageChangeListener imageChangeListener;

    public ImageWayPointLayer() {
        super(I18n.tr((String)"Imported Images", (Object[])new Object[0]));
        Main.getLayerManager().addLayer((Layer)this);
        this.layerMouseListener = new ImageWayPointMouseListener(this);
        Main.map.mapView.addMouseListener(this.layerMouseListener);
        this.imageChangeListener = new ImageChangeListener();
        ImageEntries.getInstance().addListener(this.imageChangeListener);
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"dialogs/imagewaypoint");
    }

    public Object getInfoComponent() {
        return null;
    }

    public Action[] getMenuEntries() {
        return new Action[0];
    }

    public String getToolTipText() {
        return "";
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void paint(Graphics2D graphics, MapView mapView, Bounds box) {
        ImageEntry[] images = ImageEntries.getInstance().getImages();
        if (null != images) {
            ImageEntry currentImage = ImageEntries.getInstance().getCurrentImageEntry();
            for (int index = 0; index < images.length; ++index) {
                Rectangle bounds = images[index].getBounds(mapView);
                if (null == bounds) continue;
                if (images[index] == currentImage) {
                    ImageEntry.SELECTED_ICON.paintIcon((Component)mapView, graphics, bounds.x, bounds.y);
                    continue;
                }
                ImageEntry.ICON.paintIcon((Component)mapView, graphics, bounds.x, bounds.y);
            }
        }
    }

    public void visitBoundingBox(BoundingXYVisitor visitor) {
        ImageEntry[] images = ImageEntries.getInstance().getImages();
        if (null != images) {
            for (int index = 0; index < images.length; ++index) {
                ImageEntry imageEntry = images[index];
                if (imageEntry.getWayPoint() == null) continue;
                visitor.visit(imageEntry.getWayPoint().getCoor());
            }
        }
    }

    public void destroy() {
        super.destroy();
        Main.map.mapView.removeMouseListener(this.layerMouseListener);
        ImageEntries.getInstance().removeListener(this.imageChangeListener);
    }

    private static final class ImageChangeListener
    implements IImageChangeListener {
        private ImageChangeListener() {
        }

        @Override
        public void onAvailableImageEntriesChanged(ImageEntries entries) {
            Main.map.repaint();
        }

        @Override
        public void onSelectedImageEntryChanged(ImageEntries entries) {
            Main.map.repaint();
        }
    }

    private static final class ImageWayPointMouseListener
    extends MouseAdapter {
        private final ImageWayPointLayer layer;

        ImageWayPointMouseListener(ImageWayPointLayer layer) {
            this.layer = layer;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            ImageEntry[] images;
            if (1 == event.getButton() && this.layer.isVisible() && null != (images = ImageEntries.getInstance().getImages())) {
                boolean found = false;
                for (int index = images.length - 1; !found && index >= 0; --index) {
                    Rectangle bounds = images[index].getBounds(Main.map.mapView);
                    if (null == bounds || !bounds.contains(event.getPoint())) continue;
                    found = true;
                    ImageEntries.getInstance().setCurrentImageEntry(images[index]);
                }
            }
        }
    }
}

