/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.plugin.dialogs;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessRulesetReader;
import org.openstreetmap.josm.plugins.graphview.core.visualisation.ColorScheme;
import org.openstreetmap.josm.plugins.graphview.core.visualisation.EndNodeColorScheme;
import org.openstreetmap.josm.plugins.graphview.core.visualisation.InclineColorScheme;
import org.openstreetmap.josm.plugins.graphview.core.visualisation.MaxheightColorScheme;
import org.openstreetmap.josm.plugins.graphview.core.visualisation.MaxspeedColorScheme;
import org.openstreetmap.josm.plugins.graphview.core.visualisation.MaxweightColorScheme;
import org.openstreetmap.josm.plugins.graphview.plugin.GraphViewPlugin;
import org.openstreetmap.josm.plugins.graphview.plugin.layer.PreferencesColorScheme;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.GraphViewPreferences;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.InternalRuleset;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class GraphViewDialog
extends ToggleDialog
implements Observer {
    private static final int HEIGHT = 150;
    private final LinkedHashMap<String, ColorScheme> availableColorSchemes;
    private final GraphViewPreferences preferences;
    private final GraphViewPlugin plugin;
    private final JComboBox<String> rulesetComboBox;
    private final JComboBox<String> bookmarkComboBox;
    private final JComboBox<String> colorSchemeComboBox;
    private List<File> rulesetFiles;
    private final ActionListener rulesetActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GraphViewDialog.this.rulesetComboBox.getSelectedItem() != null) {
                int selectedRulesetIndex = GraphViewDialog.this.rulesetComboBox.getSelectedIndex();
                if (GraphViewDialog.this.rulesetFiles != null) {
                    File selectedRulesetFile = (File)GraphViewDialog.this.rulesetFiles.get(selectedRulesetIndex);
                    GraphViewDialog.this.preferences.setCurrentRulesetFile(selectedRulesetFile);
                    GraphViewDialog.this.preferences.distributeChanges();
                    GraphViewDialog.this.plugin.updateGraphViewLayer();
                } else if (selectedRulesetIndex < InternalRuleset.values().length) {
                    InternalRuleset selectedIRR = InternalRuleset.values()[selectedRulesetIndex];
                    GraphViewDialog.this.preferences.setCurrentInternalRuleset(selectedIRR);
                    GraphViewDialog.this.preferences.distributeChanges();
                    GraphViewDialog.this.plugin.updateGraphViewLayer();
                }
            }
        }
    };
    private final ActionListener bookmarkActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectedBookmarkName = (String)GraphViewDialog.this.bookmarkComboBox.getSelectedItem();
            if (selectedBookmarkName != null) {
                GraphViewDialog.this.preferences.setCurrentParameterBookmarkName(selectedBookmarkName);
                GraphViewDialog.this.preferences.distributeChanges();
                GraphViewDialog.this.plugin.updateGraphViewLayer();
            }
        }
    };
    private final ActionListener colorSchemeActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (GraphViewDialog.this.availableColorSchemes.containsKey(GraphViewDialog.this.colorSchemeComboBox.getSelectedItem()));
            String colorSchemeLabel = (String)GraphViewDialog.this.colorSchemeComboBox.getSelectedItem();
            GraphViewDialog.this.preferences.setCurrentColorScheme((ColorScheme)GraphViewDialog.this.availableColorSchemes.get(colorSchemeLabel));
            GraphViewDialog.this.preferences.distributeChanges();
            GraphViewDialog.this.plugin.repaintGraphViewLayer();
        }
    };

    public GraphViewDialog(final GraphViewPlugin plugin) {
        super(I18n.tr((String)"Graph View Dialog", (Object[])new Object[0]), "graphview", I18n.tr((String)"Open the dialog for graph view configuration.", (Object[])new Object[0]), (Shortcut)null, 150);
        this.preferences = GraphViewPreferences.getInstance();
        this.plugin = plugin;
        this.availableColorSchemes = new LinkedHashMap();
        this.availableColorSchemes.put(I18n.tr((String)"default", (Object[])new Object[0]), new PreferencesColorScheme(this.preferences));
        this.availableColorSchemes.put(I18n.tr((String)"end nodes", (Object[])new Object[0]), new EndNodeColorScheme(Color.GRAY, Color.RED, Color.GRAY));
        this.availableColorSchemes.put(I18n.tr((String)"maxspeed", (Object[])new Object[0]), new MaxspeedColorScheme());
        this.availableColorSchemes.put(I18n.tr((String)"maxweight", (Object[])new Object[0]), new MaxweightColorScheme());
        this.availableColorSchemes.put(I18n.tr((String)"maxheight", (Object[])new Object[0]), new MaxheightColorScheme());
        this.availableColorSchemes.put(I18n.tr((String)"incline", (Object[])new Object[0]), new InclineColorScheme());
        JPanel selectionPanel = new JPanel();
        GridBagLayout selectionLayout = new GridBagLayout();
        selectionPanel.setLayout(selectionLayout);
        GridBagConstraints gbcLabel = new GridBagConstraints();
        gbcLabel.gridx = 0;
        gbcLabel.anchor = 17;
        gbcLabel.insets = new Insets(0, 5, 0, 5);
        GridBagConstraints gbcComboBox = new GridBagConstraints();
        gbcComboBox.gridx = 1;
        gbcComboBox.fill = 2;
        gbcComboBox.weightx = 1.0;
        JLabel rulesetLabel = new JLabel(I18n.tr((String)"Ruleset:", (Object[])new Object[0]));
        gbcLabel.gridy = 0;
        selectionLayout.setConstraints(rulesetLabel, gbcLabel);
        selectionPanel.add(rulesetLabel);
        this.rulesetComboBox = new JComboBox();
        this.rulesetComboBox.addActionListener(this.rulesetActionListener);
        gbcComboBox.gridy = 0;
        selectionLayout.setConstraints(this.rulesetComboBox, gbcComboBox);
        selectionPanel.add(this.rulesetComboBox);
        JLabel bookmarkLabel = new JLabel(I18n.tr((String)"Parameters:", (Object[])new Object[0]));
        gbcLabel.gridy = 1;
        selectionLayout.setConstraints(bookmarkLabel, gbcLabel);
        selectionPanel.add(bookmarkLabel);
        this.bookmarkComboBox = new JComboBox();
        this.bookmarkComboBox.addActionListener(this.bookmarkActionListener);
        gbcComboBox.gridy = 1;
        selectionLayout.setConstraints(this.bookmarkComboBox, gbcComboBox);
        selectionPanel.add(this.bookmarkComboBox);
        JLabel colorSchemeLabel = new JLabel(I18n.tr((String)"Coloring:", (Object[])new Object[0]));
        gbcLabel.gridy = 2;
        selectionLayout.setConstraints(colorSchemeLabel, gbcLabel);
        selectionPanel.add(colorSchemeLabel);
        this.colorSchemeComboBox = new JComboBox();
        for (String colorSchemeName : this.availableColorSchemes.keySet()) {
            this.colorSchemeComboBox.addItem(colorSchemeName);
            ColorScheme colorScheme = this.availableColorSchemes.get(colorSchemeName);
            if (!colorScheme.getClass().equals(this.preferences.getCurrentColorScheme().getClass())) continue;
            this.colorSchemeComboBox.setSelectedItem(colorSchemeName);
        }
        this.colorSchemeComboBox.addActionListener(this.colorSchemeActionListener);
        gbcComboBox.gridy = 2;
        selectionLayout.setConstraints(this.colorSchemeComboBox, gbcComboBox);
        selectionPanel.add(this.colorSchemeComboBox);
        this.createLayout(selectionPanel, true, Arrays.asList(new SideButton((Action)new AbstractAction(I18n.tr((String)"Create/update graph", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.createGraphViewLayer();
            }
        })));
        this.updateSelections();
        this.preferences.addObserver(this);
    }

    @Override
    public void update(Observable observable, Object param) {
        if (observable == this.preferences) {
            this.updateSelections();
        }
    }

    protected void updateSelections() {
        this.rulesetComboBox.removeActionListener(this.rulesetActionListener);
        if (this.preferences.getUseInternalRulesets()) {
            this.rulesetFiles = null;
            this.rulesetComboBox.removeAllItems();
            for (int i = 0; i < InternalRuleset.values().length; ++i) {
                InternalRuleset ruleset = InternalRuleset.values()[i];
                this.rulesetComboBox.addItem(ruleset.toString());
                if (ruleset != this.preferences.getCurrentInternalRuleset()) continue;
                this.rulesetComboBox.setSelectedIndex(i);
            }
            if (this.preferences.getCurrentInternalRuleset() == null) {
                this.rulesetComboBox.addItem("");
                this.rulesetComboBox.setSelectedIndex(InternalRuleset.values().length);
            }
        } else {
            this.rulesetFiles = new LinkedList<File>();
            File[] filesInRulesetFolder = this.preferences.getRulesetFolder().listFiles();
            if (filesInRulesetFolder != null) {
                for (File possibleRulesetFile : filesInRulesetFolder) {
                    try {
                        AccessRulesetReader.readAccessRuleset(new FileInputStream(possibleRulesetFile));
                        this.rulesetFiles.add(possibleRulesetFile);
                    }
                    catch (IOException ioe) {
                        Main.debug((Throwable)ioe);
                    }
                }
            }
            Collections.sort(this.rulesetFiles);
            this.rulesetComboBox.removeAllItems();
            for (int i = 0; i < this.rulesetFiles.size(); ++i) {
                File rulesetFile = this.rulesetFiles.get(i);
                this.rulesetComboBox.addItem(rulesetFile.getName());
                if (!rulesetFile.equals(this.preferences.getCurrentRulesetFile())) continue;
                this.rulesetComboBox.setSelectedIndex(i);
            }
        }
        this.rulesetComboBox.addActionListener(this.rulesetActionListener);
        this.bookmarkComboBox.removeActionListener(this.bookmarkActionListener);
        String activeBookmarkName = this.preferences.getCurrentParameterBookmarkName();
        HashSet<String> bookmarkNames = new HashSet<String>(this.preferences.getParameterBookmarks().keySet());
        this.bookmarkComboBox.removeAllItems();
        for (String bookmarkName : bookmarkNames) {
            this.bookmarkComboBox.addItem(bookmarkName);
            if (!bookmarkName.equals(activeBookmarkName)) continue;
            this.bookmarkComboBox.setSelectedItem(bookmarkName);
        }
        this.bookmarkComboBox.addActionListener(this.bookmarkActionListener);
    }
}

