/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.search;

import java.util.Arrays;
import java.util.Collection;
import org.openstreetmap.josm.actions.search.PushbackTokenizer;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.plugins.utilsplugin2.search.ConnectedMatch;
import org.openstreetmap.josm.plugins.utilsplugin2.search.InsideMatch;
import org.openstreetmap.josm.plugins.utilsplugin2.search.IntersectingMatch;

public class UtilsUnaryMatchFactory
implements SearchCompiler.UnaryMatchFactory {
    private static Collection<String> keywords = Arrays.asList("inside", "intersecting", "allintersecting", "adjacent", "connected");

    public SearchCompiler.UnaryMatch get(String keyword, SearchCompiler.Match matchOperand, PushbackTokenizer tokenizer) throws SearchCompiler.ParseError {
        if ("inside".equals(keyword)) {
            return new InsideMatch(matchOperand);
        }
        if ("adjacent".equals(keyword)) {
            return new ConnectedMatch(matchOperand, false);
        }
        if ("connected".equals(keyword)) {
            return new ConnectedMatch(matchOperand, true);
        }
        if ("intersecting".equals(keyword)) {
            return new IntersectingMatch(matchOperand, false);
        }
        if ("allintersecting".equals(keyword)) {
            return new IntersectingMatch(matchOperand, true);
        }
        return null;
    }

    public Collection<String> getKeywords() {
        return keywords;
    }
}

