/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.dataimport.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.tools.I18n;

public class TangoGPS
extends FileImporter {
    public TangoGPS() {
        super(new ExtensionFileFilter("log", "log", I18n.tr((String)"TangoGPS Files (*.log)", (Object[])new Object[0])));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        ArrayList<WayPoint> currentTrackSeg = new ArrayList<WayPoint>();
        int imported = 0;
        int failure = 0;
        try (FileInputStream source = new FileInputStream(file);
             BufferedReader rd = new BufferedReader(new InputStreamReader(source));){
            String line;
            while ((line = rd.readLine()) != null) {
                ++failure;
                String[] lineElements = line.split(",");
                if (lineElements.length < 7) continue;
                try {
                    WayPoint currentWayPoint = new WayPoint(this.parseLatLon(lineElements));
                    currentWayPoint.attr.put("ele", lineElements[2]);
                    currentWayPoint.attr.put("time", lineElements[6]);
                    currentWayPoint.setTime();
                    currentTrackSeg.add(currentWayPoint);
                    ++imported;
                }
                catch (NumberFormatException e) {
                    Main.error((Throwable)e);
                }
            }
            failure -= imported;
            if (imported > 0) {
                GpxData data = new GpxData();
                data.tracks.add(new ImmutableGpxTrack(Collections.singleton(currentTrackSeg), Collections.emptyMap()));
                data.recalculateBounds();
                data.storageFile = file;
                GpxLayer gpxLayer = new GpxLayer(data, file.getName());
                Main.getLayerManager().addLayer((Layer)gpxLayer);
                if (Main.pref.getBoolean("marker.makeautomarkers", true)) {
                    MarkerLayer ml = new MarkerLayer(data, I18n.tr((String)"Markers from {0}", (Object[])new Object[]{file.getName()}), file, gpxLayer);
                    if (ml.data.size() > 0) {
                        Main.getLayerManager().addLayer((Layer)ml);
                    }
                }
            }
            this.showInfobox(imported, failure);
            return;
        }
    }

    private double parseCoord(String s) {
        return Double.parseDouble(s);
    }

    private LatLon parseLatLon(String[] lineElements) {
        if (lineElements.length < 2) {
            return null;
        }
        return new LatLon(this.parseCoord(lineElements[0]), this.parseCoord(lineElements[1]));
    }

    private void showInfobox(int success, int failure) {
        String msg = I18n.tr((String)"Coordinates imported: ", (Object[])new Object[0]) + success + " " + I18n.tr((String)"Format errors: ", (Object[])new Object[0]) + failure + "\n";
        if (success > 0) {
            JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr((String)"TangoGPS import success", (Object[])new Object[0]), 1);
        } else {
            JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr((String)"TangoGPS import failure!", (Object[])new Object[0]), 0);
        }
    }
}

