/*
 * Decompiled with CFR 0.152.
 */
package com.tilusnet.josm.plugins.alignways;

import com.tilusnet.josm.plugins.alignways.AlignWaysSegment;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;

public class AlignWaysAlgnSegment
extends AlignWaysSegment {
    private PivotLocations currPivot;
    Map<PivotLocations, EastNorth> pivotList = new EnumMap<PivotLocations, EastNorth>(PivotLocations.class);
    private final Color pivotColor;
    private final Color crossColor = this.pivotColor = Color.YELLOW;
    private final Map<Node, ArrayList<WaySegment>> adjWaySegs = new HashMap<Node, ArrayList<WaySegment>>();

    public AlignWaysAlgnSegment(MapView mapview, Point p) throws IllegalArgumentException {
        super(mapview, p);
        this.setSegment(this.getNearestWaySegment(p));
        this.segmentColor = Color.ORANGE;
    }

    @Override
    public void setSegment(WaySegment segment) {
        super.setSegment(segment);
        this.setPivots();
    }

    @Override
    void setSegmentEndpoints(WaySegment segment) {
        super.setSegmentEndpoints(segment);
        for (Node nA : this.getSegmentEndPoints()) {
            this.adjWaySegs.put(nA, new ArrayList<WaySegment>(this.determineAdjacentWaysegments(nA)));
        }
    }

    public void updatePivotsEndpoints() {
        this.setPivots(this.currPivot);
        this.setSegmentEndpoints(this.segment);
    }

    private void setPivots(PivotLocations pivotRef) {
        if (this.segment != null) {
            for (PivotLocations pl : PivotLocations.values()) {
                this.pivotList.put(pl, this.getPivotCoord(pl));
            }
            this.setPivotReference(pivotRef);
        } else {
            this.setPivotReference(PivotLocations.NONE);
        }
    }

    private void setPivots() {
        this.setPivots(PivotLocations.CENTRE);
    }

    private void setPivotReference(PivotLocations pp) {
        this.currPivot = pp;
    }

    private EastNorth getPivotCoord(PivotLocations pp) {
        try {
            switch (pp) {
                case NODE1: {
                    return this.segment.getFirstNode().getEastNorth();
                }
                case NODE2: {
                    return this.segment.getSecondNode().getEastNorth();
                }
                case CENTRE: {
                    EastNorth n1 = this.getPivotCoord(PivotLocations.NODE1);
                    EastNorth n2 = this.getPivotCoord(PivotLocations.NODE2);
                    return n1 != null && n2 != null ? n1.getCenter(n2) : null;
                }
            }
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            Main.error((Throwable)e);
            return null;
        }
    }

    public EastNorth getCurrPivotCoord() {
        if (this.segment != null) {
            return this.getPivotCoord(this.currPivot);
        }
        return null;
    }

    public boolean updatePivot(Point clickedPoint) {
        PivotLocations tmpPivot = this.findNearbyPivot(clickedPoint);
        if (tmpPivot != PivotLocations.NONE) {
            this.setPivotReference(tmpPivot);
            return true;
        }
        return false;
    }

    private PivotLocations findNearbyPivot(Point clickedPoint) {
        PivotLocations nearest = PivotLocations.NONE;
        int snapDistance = NavigatableComponent.PROP_SNAP_DISTANCE.get();
        if (this.segment == null) {
            return PivotLocations.NONE;
        }
        for (PivotLocations pl : PivotLocations.values()) {
            if (pl.equals((Object)PivotLocations.NONE) || !(this.mapview.getPoint(this.pivotList.get((Object)pl)).distance(clickedPoint) <= (double)snapDistance)) continue;
            nearest = pl;
            break;
        }
        return nearest;
    }

    private Collection<WaySegment> determineAdjacentWaysegments(Node node) {
        HashSet<WaySegment> wsSet = new HashSet<WaySegment>();
        double radius = 10.0;
        int stepsOnCircle = 24;
        double incrementOnCircle = 0.2617993877991494;
        Point p = Main.map.mapView.getPoint(node);
        for (int i = 0; i < 24; ++i) {
            double ang = (double)i * 0.2617993877991494;
            double x = p.getX() + Math.cos(ang) * 10.0;
            double y = p.getY() + Math.sin(ang) * 10.0;
            Point pnew = new Point();
            pnew.setLocation(x, y);
            WaySegment ws = Main.map.mapView.getNearestWaySegment(pnew, AbstractPrimitive::isUsable);
            if (ws == null || ws.equals((Object)this.segment) || !ws.getFirstNode().equals((Object)node) && !ws.getSecondNode().equals((Object)node)) continue;
            wsSet.add(ws);
        }
        return wsSet;
    }

    public ArrayList<WaySegment> getAdjacentWaySegments(Node node) {
        return this.adjWaySegs.get(node);
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        super.paint(g, mv, bbox);
        if (this.segment.way.getNodesCount() <= this.segment.lowerIndex + 1) {
            Main.warn((String)"Not drawing AlignWays pivot points: underlying nodes disappeared");
            return;
        }
        this.updatePivotsEndpoints();
        for (PivotLocations pl : PivotLocations.values()) {
            if (pl == PivotLocations.NONE) continue;
            this.highlightCross(g, mv, this.pivotList.get((Object)pl));
        }
        this.highlightPivot(g, mv, this.getPivotCoord(this.currPivot));
    }

    private void highlightPivot(Graphics2D g, MapView mv, EastNorth pivot) {
        g.setColor(this.pivotColor);
        g.setStroke(new BasicStroke());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Ellipse2D.Double pvCentrePoint = new Ellipse2D.Double(mv.getPoint(pivot).getX() - 5.0, mv.getPoint(pivot).getY() - 5.0, 10.0, 10.0);
        g.fill(pvCentrePoint);
        Ellipse2D.Double pvPoint = new Ellipse2D.Double(mv.getPoint(pivot).getX() - 8.0, mv.getPoint(pivot).getY() - 8.0, 16.0, 16.0);
        g.draw(pvCentrePoint);
        g.draw(pvPoint);
    }

    private void highlightCross(Graphics2D g, MapView mv, EastNorth en) {
        double crossX = mv.getPoint(en).getX();
        double crossY = mv.getPoint(en).getY();
        double crossSize = 10.0;
        Line2D.Double crossV = new Line2D.Double(crossX, crossY - crossSize, crossX, crossY + crossSize);
        Line2D.Double crossH = new Line2D.Double(crossX - crossSize, crossY, crossX + crossSize, crossY);
        g.setColor(this.crossColor);
        g.setStroke(new BasicStroke());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.draw(crossV);
        g.draw(crossH);
    }

    private static enum PivotLocations {
        NONE,
        NODE1,
        NODE2,
        CENTRE;

    }
}

