/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmrec;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.osmrec.OSMRecPluginHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class OSMRecToggleDialog
extends ToggleDialog
implements SelectionChangedListener,
DataSetListenerAdapter.Listener {
    private final DefaultTableModel tagData = new ReadOnlyTableModel();
    private final DefaultTableModel membershipData = new ReadOnlyTableModel();
    private final JTable tagTable = new JTable(this.tagData);
    private final JTable membershipTable = new JTable(this.membershipData);
    private final JPanel bothTables = new JPanel();
    private final transient Map<String, Map<String, Integer>> valueCount = new TreeMap<String, Map<String, Integer>>();
    private final transient OSMRecPluginHelper editHelper = new OSMRecPluginHelper(this.tagData, this.valueCount);
    private final AddAction addAction = new AddAction();
    private final EditActionTrain editAction = new EditActionTrain();
    private final SideButton btnAdd = new SideButton((Action)((Object)this.addAction));
    private final SideButton btnEdit = new SideButton((Action)((Object)this.editAction));
    private final JLabel selectSth = new JLabel("<html><p>" + I18n.tr((String)"Select objects or create new objects and get recommendation.", (Object[])new Object[0]) + "</p></html>");

    public OSMRecToggleDialog() {
        super(I18n.tr((String)"Tags/Memberships", (Object[])new Object[0]), "propertiesdialog", I18n.tr((String)"Tags for selected objects.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"subwindow:properties", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Tags/Memberships", (Object[])new Object[0])}), (int)80, (int)5007), 150, true);
        System.out.println("cleaning test..");
        this.bothTables.setLayout(new GridBagLayout());
        this.bothTables.setVisible(false);
        this.tagTable.getSelectionModel().addListSelectionListener(this.editAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(this.editAction);
        JScrollPane scrollPane = (JScrollPane)this.createLayout(this.bothTables, true, Arrays.asList(this.btnAdd, this.btnEdit));
        MouseClickWatch mouseClickWatch = new MouseClickWatch();
        this.tagTable.addMouseListener(mouseClickWatch);
        this.membershipTable.addMouseListener(mouseClickWatch);
        scrollPane.addMouseListener(mouseClickWatch);
        this.editHelper.loadTagsIfNeeded();
    }

    private void editMembership(int row) {
        Relation relation = (Relation)this.membershipData.getValueAt(row, 0);
        Main.map.relationListDialog.selectRelation(relation);
    }

    private int findRow(TableModel model, Object value) {
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (!model.getValueAt(i, 0).equals(value)) continue;
            return i;
        }
        return -1;
    }

    private void updateSelection() {
        this.selectionChanged(null);
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        int selectedIndex;
        List<OsmPrimitive> newSel;
        if (this.tagTable == null) {
            return;
        }
        if (this.tagTable.getCellEditor() != null) {
            this.tagTable.getCellEditor().cancelCellEditing();
        }
        if ((newSel = Main.main.getInProgressSelection()) == null) {
            newSel = Collections.emptyList();
        }
        Relation selectedRelation = null;
        String selectedTag = this.editHelper.getChangedKey();
        if (selectedTag == null && this.tagTable.getSelectedRowCount() == 1) {
            selectedTag = (String)this.tagData.getValueAt(this.tagTable.getSelectedRow(), 0);
        }
        if (this.membershipTable.getSelectedRowCount() == 1) {
            selectedRelation = (Relation)this.membershipData.getValueAt(this.membershipTable.getSelectedRow(), 0);
        }
        this.tagData.setRowCount(0);
        HashMap<String, String> tags = new HashMap<String, String>();
        this.valueCount.clear();
        for (Map.Entry<String, Map<String, Integer>> entry : this.valueCount.entrySet()) {
            int count = 0;
            for (Map.Entry<String, Integer> e1 : entry.getValue().entrySet()) {
                count += e1.getValue().intValue();
            }
            if (count < newSel.size()) {
                entry.getValue().put("", newSel.size() - count);
            }
            this.tagData.addRow(new Object[]{entry.getKey(), entry.getValue()});
            tags.put(entry.getKey(), entry.getValue().size() == 1 ? entry.getValue().keySet().iterator().next() : I18n.tr((String)"<different>", (Object[])new Object[0]));
        }
        this.membershipData.setRowCount(0);
        HashMap<Relation, MemberInfo> roles = new HashMap<Relation, MemberInfo>();
        for (OsmPrimitive primitive : newSel) {
            for (OsmPrimitive ref : primitive.getReferrers(true)) {
                if (!(ref instanceof Relation) || ref.isIncomplete() || ref.isDeleted()) continue;
                Relation r = (Relation)ref;
                MemberInfo mi = (MemberInfo)roles.get(r);
                if (mi == null) {
                    mi = new MemberInfo(newSel);
                }
                roles.put(r, mi);
                int i = 1;
                for (RelationMember m : r.getMembers()) {
                    if (m.getMember() == primitive) {
                        mi.add(m, i);
                    }
                    ++i;
                }
            }
        }
        ArrayList arrayList = new ArrayList(roles.keySet());
        Collections.sort(arrayList, new Comparator<Relation>(){

            @Override
            public int compare(Relation o1, Relation o2) {
                int comp = Boolean.valueOf(o1.isDisabledAndHidden()).compareTo(o2.isDisabledAndHidden());
                return comp != 0 ? comp : DefaultNameFormatter.getInstance().getRelationComparator().compare(o1, o2);
            }
        });
        for (Relation r : arrayList) {
            this.membershipData.addRow(new Object[]{r, roles.get(r)});
        }
        this.membershipTable.getTableHeader().setVisible(this.membershipData.getRowCount() > 0);
        this.membershipTable.setVisible(this.membershipData.getRowCount() > 0);
        boolean hasSelection = !newSel.isEmpty();
        boolean hasTags = hasSelection && this.tagData.getRowCount() > 0;
        boolean hasMemberships = hasSelection && this.membershipData.getRowCount() > 0;
        this.addAction.setEnabled(hasSelection);
        this.editAction.setEnabled(true);
        this.tagTable.setVisible(hasTags);
        this.tagTable.getTableHeader().setVisible(hasTags);
        this.selectSth.setVisible(!hasSelection);
        if (selectedTag != null && (selectedIndex = this.findRow(this.tagData, selectedTag)) != -1) {
            this.tagTable.changeSelection(selectedIndex, 0, false, false);
        } else if (selectedRelation != null && (selectedIndex = this.findRow(this.membershipData, selectedRelation)) != -1) {
            this.membershipTable.changeSelection(selectedIndex, 0, false, false);
        } else if (hasTags) {
            this.tagTable.changeSelection(0, 0, false, false);
        } else if (hasMemberships) {
            this.membershipTable.changeSelection(0, 0, false, false);
        }
    }

    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.updateSelection();
    }

    public Tag getSelectedProperty() {
        int row = this.tagTable.getSelectedRow();
        if (row == -1) {
            return null;
        }
        TreeMap map = (TreeMap)this.tagData.getValueAt(row, 1);
        return new Tag(this.tagData.getValueAt(row, 0).toString(), map.size() > 1 ? "" : (String)map.keySet().iterator().next());
    }

    public IRelation getSelectedMembershipRelation() {
        int row = this.membershipTable.getSelectedRow();
        return row > -1 ? (IRelation)this.membershipData.getValueAt(row, 0) : null;
    }

    class EditActionTrain
    extends JosmAction
    implements ListSelectionListener {
        EditActionTrain() {
            super(I18n.tr((String)"Train a Model", (Object[])new Object[0]), "dialogs/fix", I18n.tr((String)"Start the training engine!", (Object[])new Object[0]), Shortcut.registerShortcut((String)"properties:edit", (String)I18n.tr((String)"Edit Tags", (Object[])new Object[0]), (int)83, (int)5004), false);
            this.setEnabled(true);
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            if (OSMRecToggleDialog.this.tagTable.getSelectedRowCount() == 1) {
                int row = OSMRecToggleDialog.this.tagTable.getSelectedRow();
                OSMRecToggleDialog.this.editHelper.editTag(row, false);
            } else if (OSMRecToggleDialog.this.membershipTable.getSelectedRowCount() == 1) {
                int row = OSMRecToggleDialog.this.membershipTable.getSelectedRow();
                OSMRecToggleDialog.this.editHelper.editTag(row, false);
            } else {
                OSMRecToggleDialog.this.editHelper.editTag(1, false);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(true);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends JosmAction {
        AddAction() {
            super(I18n.tr((String)"Add Recommendation", (Object[])new Object[0]), "dialogs/add", I18n.tr((String)"Add a recommended key/value pair to your object", (Object[])new Object[0]), Shortcut.registerShortcut((String)"properties:add", (String)I18n.tr((String)"Add Tag", (Object[])new Object[0]), (int)65, (int)5004), false);
        }

        public void actionPerformed(ActionEvent e) {
            OSMRecToggleDialog.this.editHelper.addTag();
            OSMRecToggleDialog.this.btnAdd.requestFocusInWindow();
        }
    }

    public static class ReadOnlyTableModel
    extends DefaultTableModel {
        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }
    }

    static class MemberInfo {
        private List<RelationMember> role = new ArrayList<RelationMember>();
        private Set<OsmPrimitive> members = new HashSet<OsmPrimitive>();
        private List<Integer> position = new ArrayList<Integer>();
        private Iterable<OsmPrimitive> selection;
        private String positionString;
        private String roleString;

        MemberInfo(Iterable<OsmPrimitive> selection) {
            this.selection = selection;
        }

        void add(RelationMember r, Integer p) {
            this.role.add(r);
            this.members.add(r.getMember());
            this.position.add(p);
        }

        public String toString() {
            return "MemberInfo{roles='" + this.roleString + '\'' + ", positions='" + this.positionString + '\'' + '}';
        }
    }

    public class MouseClickWatch
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                if (e.getSource() == OSMRecToggleDialog.this.tagTable) {
                    OSMRecToggleDialog.this.membershipTable.clearSelection();
                } else if (e.getSource() == OSMRecToggleDialog.this.membershipTable) {
                    OSMRecToggleDialog.this.tagTable.clearSelection();
                }
            } else if (e.getSource() == OSMRecToggleDialog.this.tagTable) {
                int row = OSMRecToggleDialog.this.tagTable.rowAtPoint(e.getPoint());
                if (row > -1) {
                    boolean focusOnKey = OSMRecToggleDialog.this.tagTable.columnAtPoint(e.getPoint()) == 0;
                    OSMRecToggleDialog.this.editHelper.editTag(row, focusOnKey);
                } else {
                    OSMRecToggleDialog.this.editHelper.addTag();
                }
            } else if (e.getSource() == OSMRecToggleDialog.this.membershipTable) {
                int row = OSMRecToggleDialog.this.membershipTable.rowAtPoint(e.getPoint());
                if (row > -1) {
                    OSMRecToggleDialog.this.editMembership(row);
                }
            } else {
                OSMRecToggleDialog.this.editHelper.addTag();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == OSMRecToggleDialog.this.tagTable) {
                OSMRecToggleDialog.this.membershipTable.clearSelection();
            } else if (e.getSource() == OSMRecToggleDialog.this.membershipTable) {
                OSMRecToggleDialog.this.tagTable.clearSelection();
            }
        }
    }
}

