/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.util.Iterator;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;

class LibVlcMediaListIterator
implements Iterable<libvlc_media_t>,
Iterator<libvlc_media_t> {
    private final LibVlc libvlc;
    private final libvlc_media_list_t mediaList;
    private final int count;
    private int index = -1;
    private libvlc_media_t current;

    LibVlcMediaListIterator(LibVlc libvlc, libvlc_media_list_t mediaList) {
        this.libvlc = libvlc;
        this.mediaList = mediaList;
        this.count = mediaList != null ? libvlc.libvlc_media_list_count(mediaList) : 0;
    }

    @Override
    public Iterator<libvlc_media_t> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            this.libvlc.libvlc_media_release(this.current);
            this.current = null;
        }
        return this.mediaList != null && this.index + 1 < this.count;
    }

    @Override
    public libvlc_media_t next() {
        this.current = this.libvlc.libvlc_media_list_item_at_index(this.mediaList, ++this.index);
        return this.current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

