/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.APIDataSet;
import reverter.RevertChangesetCommand;
import reverter.ReverterPlugin;

public class ReverterUploadHook
implements UploadHook {
    String pluginString;

    public ReverterUploadHook(ReverterPlugin plugin) {
        this.pluginString = "reverter_plugin/" + plugin.getPluginInformation().version;
    }

    public boolean checkUpload(APIDataSet apiDataSet) {
        if (!ReverterPlugin.reverterUsed) {
            return true;
        }
        boolean hasRevertions = false;
        for (Command cmd : Main.main.undoRedo.commands) {
            if (!(cmd instanceof RevertChangesetCommand)) continue;
            hasRevertions = true;
            break;
        }
        if (hasRevertions) {
            Main.getLayerManager().getEditDataSet().addChangeSetTag("created_by", "reverter");
        }
        return true;
    }
}

