/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.archive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.ArchiveReader;
import org.openstreetmap.josm.tools.I18n;

public class ZipReader
extends ArchiveReader {
    private final ZipInputStream zis;
    private ZipEntry entry;

    public ZipReader(InputStream in, AbstractDataSetHandler handler, boolean promptUser) {
        super(handler, handler != null ? handler.getArchiveHandler() : null, promptUser);
        this.zis = in instanceof ZipInputStream ? (ZipInputStream)in : new ZipInputStream(in);
    }

    public static DataSet parseDataSet(InputStream in, AbstractDataSetHandler handler, ProgressMonitor instance, boolean promptUser) throws IOException, XMLStreamException, FactoryConfigurationError, IllegalDataException {
        return new ZipReader(in, handler, promptUser).parseDoc(instance);
    }

    public static Map<File, DataSet> parseDataSets(InputStream in, AbstractDataSetHandler handler, ProgressMonitor instance, boolean promptUser) throws IOException, XMLStreamException, FactoryConfigurationError, IllegalDataException {
        return new ZipReader(in, handler, promptUser).parseDocs(instance);
    }

    @Override
    protected void extractArchive(File temp, List<File> candidates) throws IOException, FileNotFoundException {
        while ((this.entry = this.zis.getNextEntry()) != null) {
            File file;
            File parent;
            if (Main.isDebugEnabled()) {
                Main.debug((String)("Extracting " + this.entry.getName()));
            }
            if ((parent = (file = new File(temp + File.separator + this.entry.getName())).getParentFile()) != null && !parent.exists()) {
                parent.mkdirs();
            }
            if (file.exists() && !file.delete()) {
                throw new IOException("Could not delete temp file/dir: " + file.getAbsolutePath());
            }
            if (!this.entry.isDirectory()) {
                long time;
                if (!file.createNewFile()) {
                    throw new IOException("Could not create temp file: " + file.getAbsolutePath());
                }
                try (FileOutputStream fos = new FileOutputStream(file);){
                    byte[] buffer = new byte[8192];
                    int count = 0;
                    while ((count = this.zis.read(buffer, 0, buffer.length)) > 0) {
                        fos.write(buffer, 0, count);
                    }
                }
                if (this.archiveHandler != null) {
                    this.archiveHandler.notifyTempFileWritten(file);
                }
                if ((time = this.entry.getTime()) > -1L) {
                    file.setLastModified(time);
                }
                this.lookForCandidate(this.entry.getName(), candidates, file);
                continue;
            }
            if (file.mkdir()) continue;
            throw new IOException("Could not create temp dir: " + file.getAbsolutePath());
        }
    }

    @Override
    protected String getTaskMessage() {
        return I18n.tr((String)"Reading Zip file...", (Object[])new Object[0]);
    }
}

