/*
 * Decompiled with CFR 0.152.
 */
package ext_tools;

import ext_tools.ExtTool;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.Main;

public class ToolsInformation {
    String filename;
    ArrayList<ExtTool> tools = new ArrayList();

    public ToolsInformation(String filename) {
        this.filename = filename;
        this.load();
    }

    public void load() {
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filename), "UTF-8"));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = rdr.readLine()) != null) {
                sb.append(line).append('\n');
                if (!line.equals("")) continue;
                this.tools.add(ExtTool.unserialize(sb.toString()));
                sb = new StringBuilder();
            }
        }
        catch (Exception e) {
            Main.warn((String)("Ext_Tools warning: can not load file " + this.filename));
        }
    }

    public void save() {
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(this.filename), "UTF-8");){
            for (ExtTool tool : this.tools) {
                w.write(tool.serialize());
            }
        }
        catch (Exception e) {
            Main.warn((String)("Ext_Tools warning: can not save file " + this.filename));
        }
    }

    public List<ExtTool> getToolsList() {
        return this.tools;
    }

    public void addTool(ExtTool tool) {
        this.tools.add(tool);
    }

    public void removeTool(ExtTool tool) {
        tool.setEnabled(false);
        this.tools.remove(tool);
    }
}

