/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.layer;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;
import org.openstreetmap.josm.tools.I18n;

public class PicLayerFromFile
extends PicLayerAbstract {
    private File m_file;
    private boolean isZip;
    private String imgNameInZip;
    private String m_tooltiptext;

    public PicLayerFromFile(File file) {
        this.m_file = file;
        if ("zip".equalsIgnoreCase(PicLayerFromFile.getFileExtension(file))) {
            this.isZip = true;
        }
        this.m_tooltiptext = this.m_file.getAbsolutePath();
        this.setName(this.m_file.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Image createImage() throws IOException {
        BufferedImage image = null;
        if (!this.isZip) {
            return ImageIO.read(this.m_file);
        }
        try (ZipFile zipFile = new ZipFile(this.m_file);){
            ZipEntry imgEntry = null;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            String[] supportedImageExtensions = ImageIO.getReaderFormatNames();
            block13: while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                for (String extension : supportedImageExtensions) {
                    if (!entry.getName().endsWith("." + extension)) continue;
                    imgEntry = entry;
                    break block13;
                }
            }
            if (imgEntry != null) {
                this.imgNameInZip = imgEntry.getName();
                Throwable throwable = null;
                try (InputStream is = zipFile.getInputStream(imgEntry);){
                    BufferedImage bufferedImage = ImageIO.read(is);
                    return bufferedImage;
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            System.err.println("Warning: no image in zip file found");
            Image image2 = null;
            return image2;
        }
        catch (Exception e) {
            System.err.println(I18n.tr((String)"Warning: failed to handle zip file ''{0}''. Exception was: {1}", (Object[])new Object[]{this.m_file.getName(), e.toString()}));
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void lookForCalibration() throws IOException {
        String[][] imgExtensions = new String[][]{{".jpg", ".jpeg"}, {".png"}, {".tif", ".tiff"}, {".bmp"}};
        String[][] wldExtensions = new String[][]{{".wld", ".jgw", ".jpgw"}, {".wld", ".pgw", ".pngw"}, {".wld", ".tfw", ".tifw"}, {".wld", ".bmpw", ".bpw"}};
        if (this.isZip) {
            try (ZipFile zipFile = new ZipFile(this.m_file);){
                String calFileStr = this.imgNameInZip + ".cal";
                ZipEntry calEntry = zipFile.getEntry(calFileStr);
                if (calEntry != null) {
                    if (!this.confirmCalibrationLoading(calFileStr)) return;
                    InputStream is = zipFile.getInputStream(calEntry);
                    this.loadCalibration(is);
                    return;
                }
                int dotIdx = this.imgNameInZip.lastIndexOf(".");
                if (dotIdx == -1) {
                    return;
                }
                String extension = this.imgNameInZip.substring(dotIdx);
                String namepart = this.imgNameInZip.substring(0, dotIdx);
                for (int i = 0; i < imgExtensions.length; ++i) {
                    if (!Arrays.asList(imgExtensions[i]).contains(extension.toLowerCase())) continue;
                    for (String wldExtension : wldExtensions[i]) {
                        String wldName = namepart + wldExtension;
                        ZipEntry wldEntry = zipFile.getEntry(wldName);
                        if (wldEntry == null || !this.confirmCalibrationLoading(wldName)) continue;
                        InputStream is = zipFile.getInputStream(wldEntry);
                        this.loadWorldfile(is);
                        return;
                    }
                }
                return;
            }
            catch (Exception e) {
                Main.warn((String)I18n.tr((String)"Warning: failed to handle zip file ''{0}''. Exception was: {1}", (Object[])new Object[]{this.m_file.getName(), e.toString()}));
                return;
            }
        } else {
            File calFile = new File(this.m_file + ".cal");
            if (calFile.exists()) {
                if (!this.confirmCalibrationLoading(calFile.getName())) return;
                this.loadCalibration(new FileInputStream(calFile));
                return;
            } else {
                int dotIdx = this.m_file.getName().lastIndexOf(".");
                if (dotIdx == -1) {
                    return;
                }
                String extension = this.m_file.getName().substring(dotIdx);
                String namepart = this.m_file.getName().substring(0, dotIdx);
                for (int i = 0; i < imgExtensions.length; ++i) {
                    if (!Arrays.asList(imgExtensions[i]).contains(extension.toLowerCase())) continue;
                    for (String wldExtension : wldExtensions[i]) {
                        File wldFile = new File(this.m_file.getParentFile(), namepart + wldExtension);
                        if (!wldFile.exists()) continue;
                        this.loadWorldfile(new FileInputStream(wldFile));
                        return;
                    }
                }
            }
        }
    }

    protected boolean confirmCalibrationLoading(String fileName) {
        String prefkey = "piclayer.autoloadcal";
        String policy = Main.pref.get(prefkey, "");
        policy = policy.trim().toLowerCase();
        boolean loadcal = false;
        String msg = I18n.tr((String)"A calibration file associated to the picture file was found: {0}\n", (Object[])new Object[]{fileName});
        if (policy.equals("yes")) {
            loadcal = true;
        } else if (policy.equals("no")) {
            loadcal = false;
        } else if (policy.equals("ask")) {
            msg = msg + "\n" + I18n.tr((String)"Set \"{0}\" to yes/no/ask in the preferences\nto control the autoloading of calibration files.", (Object[])new Object[]{prefkey});
            int answer = JOptionPane.showConfirmDialog(Main.parent, msg = msg + "\n" + I18n.tr((String)"Do you want to apply it ?", (Object[])new Object[0]), I18n.tr((String)"Load calibration file?", (Object[])new Object[0]), 0);
            if (answer == 0) {
                loadcal = true;
            }
        } else {
            msg = msg + "\n" + I18n.tr((String)"It will be applied automatically.", (Object[])new Object[0]);
            msg = msg + "\n" + I18n.tr((String)"Also, from now on, calibration files will always be loaded automatically.", (Object[])new Object[0]);
            msg = msg + "\n" + I18n.tr((String)"Set \"{0}\" to yes/no/ask in the preferences\nto control the autoloading of calibration files.", (Object[])new Object[]{prefkey});
            JOptionPane.showMessageDialog(Main.parent, msg, "Automatic loading of the calibration", 1);
            Main.pref.put(prefkey, "yes");
            loadcal = true;
        }
        return loadcal;
    }

    @Override
    public String getPicLayerName() {
        return this.m_tooltiptext;
    }

    public static String getFileExtension(File f) {
        int dotIdx = f.getName().lastIndexOf(46);
        if (dotIdx == -1) {
            return "";
        }
        return f.getName().substring(dotIdx + 1);
    }

    public static class CalData {
        public String[] imgExt;
        public String[] calExt;
        public CalibrationType type;

        public CalData(String[] imgExt, String[] calExt, CalibrationType type) {
            this.imgExt = imgExt;
            this.calExt = calExt;
            this.type = type;
        }
    }

    public static enum CalibrationType {
        CAL,
        WORLDFILE;

    }
}

