/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.namemanager.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.plugins.namemanager.countryData.Country;
import org.openstreetmap.josm.plugins.namemanager.countryData.CountryDataMemory;
import org.openstreetmap.josm.plugins.namemanager.utils.NameManagerUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public final class NameManagerDialog
extends JDialog {
    private static final String TAG_NAME = "Tag name";
    private static final String TAG_VALUE = "Tag value";
    private static final String ADMINISTRATIVE = "Administrative";
    private static final String ADD = "Add";
    private static final String EDIT = "Edit";
    private static final String DELETE = "Delete";
    private static final String TAG_BUILDINGS = "Tag buildings";
    private static final String COUNTRY = "Country";
    private static NameManagerDialog dialog;
    private static final int height = 400;
    private static final int width = 300;
    private static final long serialVersionUID = 4289136772379693178L;
    private Dimension dimension = new Dimension(300, 400);
    private Way selectedWay;
    private List<Way> waysInsideSelectedArea;
    private JTabbedPane tabPanel;
    private JComboBox<String> country;
    private JLabel labelLevel1;
    private JTextField level1;
    private JLabel labelLevel2;
    private JTextField level2;
    private JLabel labelLevel3;
    private JTextField level3;
    private JLabel labelLevel4;
    private JTextField level4;
    private JLabel labelLevel5;
    private JTextField level5;
    private JLabel labelLevel6;
    private JTextField level6;
    private JLabel labelTagNameAM;
    private AutoCompletingTextField tagNameAM;
    private JLabel labelTagNameD;
    private AutoCompletingTextField tagNameD;
    private JLabel labelTagValueAM;
    private AutoCompletingTextField tagValueAM;
    private JCheckBox buildings;
    private JButton addModifyButton;
    private JButton deleteButton;

    private NameManagerDialog() {
        super((JFrame)Main.parent, "Name Manager", true);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        JMenu aboutMenu = new JMenu(I18n.tr((String)"About", (Object[])new Object[0]));
        JMenuItem aboutAppButton = new JMenuItem(I18n.tr((String)"About Plugin", (Object[])new Object[0]));
        aboutAppButton.addActionListener(e -> {
            String newline = System.getProperty("line.separator");
            JOptionPane.showMessageDialog(this, "Authors:" + newline + "Rafal Jachowicz, Marek Strassenburg-Kleciak" + newline + "Consultant:" + newline + "Stefanie Otte" + newline + "Powered by:" + newline + "Harman Becker Automotive Systems GmbH" + newline + "Neusoft Technology Solutions GmbH", I18n.tr((String)"About", (Object[])new Object[0]), 1);
        });
        aboutMenu.add(aboutAppButton);
        menuBar.add(aboutMenu);
        this.setJMenuBar(menuBar);
        this.tabPanel = new JTabbedPane();
        this.tabPanel.setTabPlacement(1);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JButton saveButton = new JButton(new SaveAction());
        JButton cancelButton = new JButton(new CancelAction());
        buttonPanel.add((Component)cancelButton, "Center");
        cp.add((Component)buttonPanel, "South");
        JPanel administrativePanel = new JPanel();
        administrativePanel.setLayout(new BoxLayout(administrativePanel, 3));
        JPanel levelPanel = new JPanel(new GridLayout(7, 2, 5, 2));
        levelPanel.setAlignmentX(0.5f);
        this.buildings = new JCheckBox(I18n.tr((String)TAG_BUILDINGS, (Object[])new Object[0]));
        this.buildings.setSelected(false);
        JLabel labelCountry = new JLabel("  " + I18n.tr((String)COUNTRY, (Object[])new Object[0]));
        this.country = new JComboBox();
        this.labelLevel1 = new JLabel("  level1");
        this.level1 = new JTextField();
        this.labelLevel2 = new JLabel("  level2");
        this.level2 = new JTextField();
        this.labelLevel3 = new JLabel("  level3");
        this.level3 = new JTextField();
        this.labelLevel4 = new JLabel("  level4");
        this.level4 = new JTextField();
        this.labelLevel5 = new JLabel("  level5");
        this.level5 = new JTextField();
        this.labelLevel6 = new JLabel("  level6");
        this.level6 = new JTextField();
        levelPanel.add(labelCountry);
        levelPanel.add(this.country);
        levelPanel.add(this.labelLevel1);
        levelPanel.add(this.level1);
        levelPanel.add(this.labelLevel2);
        levelPanel.add(this.level2);
        levelPanel.add(this.labelLevel3);
        levelPanel.add(this.level3);
        levelPanel.add(this.labelLevel4);
        levelPanel.add(this.level4);
        levelPanel.add(this.labelLevel5);
        levelPanel.add(this.level5);
        levelPanel.add(this.labelLevel6);
        levelPanel.add(this.level6);
        administrativePanel.add(Box.createRigidArea(new Dimension(0, 20)));
        administrativePanel.add(this.buildings);
        administrativePanel.add(Box.createRigidArea(new Dimension(0, 10)));
        administrativePanel.add(levelPanel);
        administrativePanel.add(Box.createRigidArea(new Dimension(0, 10)));
        administrativePanel.add(saveButton);
        administrativePanel.add(Box.createRigidArea(new Dimension(0, 20)));
        JPanel addModifyPanel = new JPanel();
        addModifyPanel.setLayout(new BoxLayout(addModifyPanel, 3));
        this.labelTagNameAM = new JLabel(I18n.tr((String)TAG_NAME, (Object[])new Object[0]));
        this.tagNameAM = new AutoCompletingTextField();
        AutoCompletionList list = new AutoCompletionList();
        Main.getLayerManager().getEditLayer().data.getAutoCompletionManager().populateWithKeys(list);
        this.tagNameAM.setAutoCompletionList(list);
        this.labelTagValueAM = new JLabel(I18n.tr((String)TAG_VALUE, (Object[])new Object[0]));
        this.tagValueAM = new AutoCompletingTextField();
        this.tagNameAM.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent arg0) {
                if (!"".equals(NameManagerDialog.this.tagNameAM.getText())) {
                    AutoCompletionList list = NameManagerDialog.this.tagValueAM.getAutoCompletionList();
                    if (list == null) {
                        list = new AutoCompletionList();
                    }
                    list.clear();
                    Main.getLayerManager().getEditLayer().data.getAutoCompletionManager().populateWithTagValues(list, NameManagerDialog.this.tagNameAM.getText());
                    NameManagerDialog.this.tagValueAM.setAutoCompletionList(list);
                }
            }
        });
        this.addModifyButton = new JButton(new AddModifyAction());
        addModifyPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        addModifyPanel.add(this.labelTagNameAM);
        addModifyPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        addModifyPanel.add((Component)this.tagNameAM);
        addModifyPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        addModifyPanel.add(this.labelTagValueAM);
        addModifyPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        addModifyPanel.add((Component)this.tagValueAM);
        addModifyPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        addModifyPanel.add(this.addModifyButton);
        addModifyPanel.add(Box.createRigidArea(new Dimension(0, 170)));
        JPanel deletePanel = new JPanel();
        deletePanel.setLayout(new BoxLayout(deletePanel, 3));
        this.labelTagNameD = new JLabel(I18n.tr((String)TAG_NAME, (Object[])new Object[0]));
        this.tagNameD = new AutoCompletingTextField();
        this.tagNameD.setAutoCompletionList(list);
        this.deleteButton = new JButton(new DeleteAction());
        deletePanel.add(Box.createRigidArea(new Dimension(0, 20)));
        deletePanel.add(this.labelTagNameD);
        deletePanel.add(Box.createRigidArea(new Dimension(0, 10)));
        deletePanel.add((Component)this.tagNameD);
        deletePanel.add(Box.createRigidArea(new Dimension(0, 10)));
        deletePanel.add(this.deleteButton);
        deletePanel.add(Box.createRigidArea(new Dimension(0, 228)));
        this.tabPanel.addTab(I18n.tr((String)ADD, (Object[])new Object[0]) + "/" + I18n.tr((String)EDIT, (Object[])new Object[0]), addModifyPanel);
        this.tabPanel.addTab(I18n.tr((String)DELETE, (Object[])new Object[0]), deletePanel);
        this.tabPanel.addTab(I18n.tr((String)ADMINISTRATIVE, (Object[])new Object[0]), administrativePanel);
        cp.add((Component)this.tabPanel, "Center");
        this.setPreferredSize(this.dimension);
        this.setSize(this.dimension);
        this.setResizable(false);
    }

    public void setCountryComboBox() {
        Set<String> keySetUnsorted = CountryDataMemory.getCountryCache().keySet();
        ArrayList<String> keySet = new ArrayList<String>(keySetUnsorted);
        Collections.sort(keySet);
        this.country.removeAllItems();
        for (String string : keySet) {
            this.country.addItem(string);
        }
        String countryName = (String)this.country.getSelectedItem();
        if (CountryDataMemory.getCountryCache().containsKey(countryName)) {
            Country countryItem = CountryDataMemory.getCountryCache().get(countryName);
            this.labelLevel1.setText("  " + countryItem.getLevel1());
            if ("  n/a".equals(this.labelLevel1.getText())) {
                this.level1.setEnabled(false);
            } else {
                this.level1.setEnabled(true);
            }
            this.labelLevel2.setText("  " + countryItem.getLevel2());
            if ("  n/a".equals(this.labelLevel2.getText())) {
                this.level2.setEnabled(false);
            } else {
                this.level2.setEnabled(true);
            }
            this.labelLevel3.setText("  " + countryItem.getLevel3());
            if ("  n/a".equals(this.labelLevel3.getText())) {
                this.level3.setEnabled(false);
            } else {
                this.level3.setEnabled(true);
            }
            this.labelLevel4.setText("  " + countryItem.getLevel4());
            if ("  n/a".equals(this.labelLevel4.getText())) {
                this.level4.setEnabled(false);
            } else {
                this.level4.setEnabled(true);
            }
            this.labelLevel5.setText("  " + countryItem.getLevel5());
            if ("  n/a".equals(this.labelLevel5.getText())) {
                this.level5.setEnabled(false);
            } else {
                this.level5.setEnabled(true);
            }
            this.labelLevel6.setText("  " + countryItem.getLevel6());
            if ("  n/a".equals(this.labelLevel6.getText())) {
                this.level6.setEnabled(false);
            } else {
                this.level6.setEnabled(true);
            }
        }
        this.country.addActionListener(e -> {
            String countryName1 = (String)this.country.getSelectedItem();
            if (CountryDataMemory.getCountryCache().containsKey(countryName1)) {
                Country countryItem = CountryDataMemory.getCountryCache().get(countryName1);
                this.labelLevel1.setText("  " + countryItem.getLevel1());
                if ("  n/a".equals(this.labelLevel1.getText())) {
                    this.level1.setEnabled(false);
                } else {
                    this.level1.setEnabled(true);
                }
                this.labelLevel2.setText("  " + countryItem.getLevel2());
                if ("  n/a".equals(this.labelLevel2.getText())) {
                    this.level2.setEnabled(false);
                } else {
                    this.level2.setEnabled(true);
                }
                this.labelLevel3.setText("  " + countryItem.getLevel3());
                if ("  n/a".equals(this.labelLevel3.getText())) {
                    this.level3.setEnabled(false);
                } else {
                    this.level3.setEnabled(true);
                }
                this.labelLevel4.setText("  " + countryItem.getLevel4());
                if ("  n/a".equals(this.labelLevel4.getText())) {
                    this.level4.setEnabled(false);
                } else {
                    this.level4.setEnabled(true);
                }
                this.labelLevel5.setText("  " + countryItem.getLevel5());
                if ("  n/a".equals(this.labelLevel5.getText())) {
                    this.level5.setEnabled(false);
                } else {
                    this.level5.setEnabled(true);
                }
                this.labelLevel6.setText("  " + countryItem.getLevel6());
                if ("  n/a".equals(this.labelLevel6.getText())) {
                    this.level6.setEnabled(false);
                } else {
                    this.level6.setEnabled(true);
                }
            }
        });
    }

    public static NameManagerDialog getInstance() {
        if (dialog == null) {
            dialog = new NameManagerDialog();
            NameManagerDialog.centerDialog(dialog);
        }
        NameManagerDialog.dialog.buildings.setSelected(false);
        return dialog;
    }

    private static void centerDialog(NameManagerDialog dialog) {
        Window window = NameManagerUtils.getTopWindow();
        if (window == null) {
            return;
        }
        GraphicsConfiguration gc = window.getGraphicsConfiguration();
        if (gc != null) {
            Rectangle screenBounds = gc.getBounds();
            Rectangle windowBounds = window.getBounds();
            Dimension d = dialog.getPreferredSize();
            Point p = new Point();
            if (d.width <= windowBounds.width && d.height <= windowBounds.height) {
                p.x = windowBounds.x + (windowBounds.width - d.width) / 2;
                p.y = windowBounds.y + (windowBounds.height - d.height) / 2;
            } else {
                p.x = screenBounds.x + (screenBounds.width - d.width) / 2;
                p.y = screenBounds.y + (screenBounds.height - d.height) / 2;
            }
            dialog.setLocation(p);
        }
    }

    public Way getSelectedWay() {
        return this.selectedWay;
    }

    public void setSelectedWay(Way selectedWay) {
        this.selectedWay = selectedWay;
    }

    public List<Way> getWaysInsideSelectedArea() {
        return this.waysInsideSelectedArea;
    }

    public void setWaysInsideSelectedArea(List<Way> waysInsideSelectedArea) {
        this.waysInsideSelectedArea = waysInsideSelectedArea;
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            this.putValue("Name", I18n.tr((String)"Save", (Object[])new Object[0]));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0));
            ImageIcon saveIcon = ImageProvider.get((String)"", (String)"save");
            if (saveIcon != null) {
                this.putValue("SmallIcon", saveIcon);
            }
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (NameManagerDialog.this.selectedWay != null && NameManagerDialog.this.waysInsideSelectedArea != null && !NameManagerDialog.this.waysInsideSelectedArea.isEmpty()) {
                String countryName = (String)NameManagerDialog.this.country.getSelectedItem();
                Country countryItem = null;
                if (CountryDataMemory.getCountryCache().containsKey(countryName)) {
                    countryItem = CountryDataMemory.getCountryCache().get(countryName);
                }
                for (Way way : NameManagerDialog.this.waysInsideSelectedArea) {
                    if (NameManagerDialog.this.tabPanel.getSelectedIndex() == 2) {
                        if (way.get("building") != null && !NameManagerDialog.this.buildings.isSelected()) continue;
                        way.put("country", countryName);
                        if (countryItem != null) {
                            way.put("level1", NameManagerDialog.this.level1.getText());
                            way.put("level2", NameManagerDialog.this.level2.getText());
                            way.put("level3", NameManagerDialog.this.level3.getText());
                            way.put("level4", NameManagerDialog.this.level4.getText());
                            way.put("level5", NameManagerDialog.this.level5.getText());
                            way.put("level6", NameManagerDialog.this.level6.getText());
                        }
                    }
                    way.save();
                }
            }
            NameManagerDialog.this.setVisible(false);
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr((String)"Cancel", (Object[])new Object[0]));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
            ImageIcon cancelIcon = ImageProvider.get((String)"", (String)"cancel");
            if (cancelIcon != null) {
                this.putValue("SmallIcon", cancelIcon);
            }
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            NameManagerDialog.this.setVisible(false);
        }
    }

    class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            this.putValue("Name", I18n.tr((String)NameManagerDialog.DELETE, (Object[])new Object[0]));
            ImageIcon deleteIcon = ImageProvider.get((String)"", (String)"purge");
            if (deleteIcon != null) {
                this.putValue("SmallIcon", deleteIcon);
            }
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (NameManagerDialog.this.selectedWay != null && NameManagerDialog.this.waysInsideSelectedArea != null && !NameManagerDialog.this.waysInsideSelectedArea.isEmpty() && NameManagerDialog.this.tabPanel.getSelectedIndex() == 1) {
                for (Way way : NameManagerDialog.this.waysInsideSelectedArea) {
                    if ("".equals(NameManagerDialog.this.tagNameD.getText())) continue;
                    way.remove(NameManagerDialog.this.tagNameD.getText());
                    way.save();
                }
            }
            NameManagerDialog.this.setVisible(false);
        }
    }

    class AddModifyAction
    extends AbstractAction {
        AddModifyAction() {
            this.putValue("Name", I18n.tr((String)NameManagerDialog.ADD, (Object[])new Object[0]) + "/" + I18n.tr((String)NameManagerDialog.EDIT, (Object[])new Object[0]));
            ImageIcon addModifyIcon = ImageProvider.get((String)"", (String)"addnode");
            if (addModifyIcon != null) {
                this.putValue("SmallIcon", addModifyIcon);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NameManagerDialog.this.selectedWay != null && NameManagerDialog.this.waysInsideSelectedArea != null && !NameManagerDialog.this.waysInsideSelectedArea.isEmpty() && NameManagerDialog.this.tabPanel.getSelectedIndex() == 0) {
                for (Way way : NameManagerDialog.this.waysInsideSelectedArea) {
                    if ("".equals(NameManagerDialog.this.tagNameAM.getText()) || "".equals(NameManagerDialog.this.tagValueAM.getText())) continue;
                    way.put(NameManagerDialog.this.tagNameAM.getText(), NameManagerDialog.this.tagValueAM.getText());
                    way.save();
                }
            }
            NameManagerDialog.this.setVisible(false);
        }
    }
}

