/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Point;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

public class LiveGpsData {
    private boolean fix = true;
    private LatLon latLon;
    private float course;
    private float speed;
    private float epx;
    private float epy;
    private String wayString;
    private Way way;

    public LiveGpsData(double latitude, double longitude, float course, float speed) {
        this.latLon = new LatLon(latitude, longitude);
        this.course = course;
        this.speed = speed;
    }

    public LiveGpsData(double latitude, double longitude, float course, float speed, float epx, float epy) {
        this.latLon = new LatLon(latitude, longitude);
        this.course = course;
        this.speed = speed;
        this.epx = epx;
        this.epy = epy;
    }

    public float getCourse() {
        return this.course;
    }

    public void setCourse(float course) {
        this.course = course;
    }

    public boolean isFix() {
        return this.fix;
    }

    public void setFix(boolean haveFix) {
        this.fix = haveFix;
    }

    public double getLatitude() {
        return this.latLon.lat();
    }

    public double getLongitude() {
        return this.latLon.lon();
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public LatLon getLatLon() {
        return this.latLon;
    }

    public void setLatLon(LatLon latLon) {
        this.latLon = latLon;
    }

    public void setEpy(float epy) {
        this.epy = epy;
    }

    public void setEpx(float epx) {
        this.epx = epx;
    }

    public float getEpy() {
        return this.epy;
    }

    public float getEpx() {
        return this.epx;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[fix=" + this.fix + ", lat=" + this.latLon.lat() + ", long=" + this.latLon.lon() + ", speed=" + this.speed + ", course=" + this.course + ']';
    }

    public String getWayInfo() {
        if (this.wayString == null) {
            Way way = this.getWay();
            if (way != null) {
                StringBuilder builder = new StringBuilder();
                String tmp = way.get("name");
                if (tmp != null) {
                    builder.append(tmp);
                } else {
                    builder.append(I18n.tr((String)"no name", (Object[])new Object[0]));
                }
                tmp = way.get("ref");
                if (tmp != null) {
                    builder.append(" (").append(tmp).append(")");
                }
                if ((tmp = way.get("highway")) != null) {
                    builder.append(" {").append(tmp).append("}");
                }
                String type = "";
                tmp = way.get("tunnel");
                if (tmp != null) {
                    type = type + "T";
                }
                if ((tmp = way.get("bridge")) != null) {
                    type = type + "B";
                }
                if (type.length() > 0) {
                    builder.append(" [").append(type).append("]");
                }
                this.wayString = builder.toString();
            } else {
                this.wayString = "";
            }
        }
        return this.wayString;
    }

    public Way getWay() {
        if (this.way == null && Main.map != null && Main.map.mapView != null) {
            Point xy = Main.map.mapView.getPoint(this.getLatLon());
            this.way = Main.map.mapView.getNearestWay(xy, AbstractPrimitive::isUsable);
        }
        return this.way;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.course);
        result = 31 * result + (this.latLon == null ? 0 : this.latLon.hashCode());
        result = 31 * result + Float.floatToIntBits(this.speed);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LiveGpsData other = (LiveGpsData)obj;
        if (Float.floatToIntBits(this.course) != Float.floatToIntBits(other.course)) {
            return false;
        }
        if (this.latLon == null ? other.latLon != null : !this.latLon.equals((Object)other.latLon)) {
            return false;
        }
        return Float.floatToIntBits(this.speed) == Float.floatToIntBits(other.speed);
    }
}

