/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.datareaders;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffImageData;
import org.apache.commons.imaging.formats.tiff.datareaders.BitInputStream;
import org.apache.commons.imaging.formats.tiff.datareaders.ImageDataReader;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterRgb;

public final class DataReaderStrips
extends ImageDataReader {
    private final int bitsPerPixel;
    private final int compression;
    private final int rowsPerStrip;
    private final ByteOrder byteOrder;
    private int x;
    private int y;
    private final TiffImageData.Strips imageData;

    public DataReaderStrips(TiffDirectory directory, PhotometricInterpreter photometricInterpreter, int bitsPerPixel, int[] bitsPerSample, int predictor, int samplesPerPixel, int width, int height, int compression, ByteOrder byteOrder, int rowsPerStrip, TiffImageData.Strips imageData) {
        super(directory, photometricInterpreter, bitsPerSample, predictor, samplesPerPixel, width, height);
        this.bitsPerPixel = bitsPerPixel;
        this.compression = compression;
        this.rowsPerStrip = rowsPerStrip;
        this.imageData = imageData;
        this.byteOrder = byteOrder;
    }

    private void interpretStrip(ImageBuilder imageBuilder, byte[] bytes, int pixelsPerStrip, int yLimit) throws ImageReadException, IOException {
        if (this.y >= yLimit) {
            return;
        }
        boolean allSamplesAreOneByte = this.isHomogenous(8);
        if (this.predictor != 2 && this.bitsPerPixel == 8 && allSamplesAreOneByte) {
            int k = 0;
            int nRows = pixelsPerStrip / this.width;
            if (this.y + nRows > yLimit) {
                nRows = yLimit - this.y;
            }
            int i0 = this.y;
            int i1 = this.y + nRows;
            this.x = 0;
            this.y += nRows;
            int[] samples = new int[1];
            for (int i = i0; i < i1; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    samples[0] = bytes[k++] & 0xFF;
                    this.photometricInterpreter.interpretPixel(imageBuilder, samples, j, i);
                }
            }
            return;
        }
        if (this.predictor != 2 && this.bitsPerPixel == 24 && allSamplesAreOneByte) {
            int k = 0;
            int nRows = pixelsPerStrip / this.width;
            if (this.y + nRows > yLimit) {
                nRows = yLimit - this.y;
            }
            int i0 = this.y;
            int i1 = this.y + nRows;
            this.x = 0;
            this.y += nRows;
            if (this.photometricInterpreter instanceof PhotometricInterpreterRgb) {
                for (int i = i0; i < i1; ++i) {
                    int j = 0;
                    while (j < this.width) {
                        int rgb = 0xFF000000 | (bytes[k] << 8 | bytes[k + 1] & 0xFF) << 8 | bytes[k + 2] & 0xFF;
                        imageBuilder.setRGB(j, i, rgb);
                        ++j;
                        k += 3;
                    }
                }
            } else {
                int[] samples = new int[3];
                for (int i = i0; i < i1; ++i) {
                    for (int j = 0; j < this.width; ++j) {
                        samples[0] = bytes[k++] & 0xFF;
                        samples[1] = bytes[k++] & 0xFF;
                        samples[2] = bytes[k++] & 0xFF;
                        this.photometricInterpreter.interpretPixel(imageBuilder, samples, j, i);
                    }
                }
            }
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        BitInputStream bis = new BitInputStream(bais, this.byteOrder);
        int[] samples = new int[this.bitsPerSampleLength];
        this.resetPredictor();
        for (int i = 0; i < pixelsPerStrip; ++i) {
            this.getSamplesAsBytes(bis, samples);
            if (this.x < this.width) {
                samples = this.applyPredictor(samples);
                this.photometricInterpreter.interpretPixel(imageBuilder, samples, this.x, this.y);
            }
            ++this.x;
            if (this.x < this.width) continue;
            this.x = 0;
            this.resetPredictor();
            ++this.y;
            bis.flushCache();
            if (this.y >= yLimit) break;
        }
    }

    @Override
    public void readImageData(ImageBuilder imageBuilder) throws ImageReadException, IOException {
        for (int strip = 0; strip < this.imageData.getImageDataLength(); ++strip) {
            long rowsPerStripLong = 0xFFFFFFFFL & (long)this.rowsPerStrip;
            long rowsRemaining = (long)this.height - (long)strip * rowsPerStripLong;
            long rowsInThisStrip = Math.min(rowsRemaining, rowsPerStripLong);
            long bytesPerRow = (this.bitsPerPixel * this.width + 7) / 8;
            long bytesPerStrip = rowsInThisStrip * bytesPerRow;
            long pixelsPerStrip = rowsInThisStrip * (long)this.width;
            byte[] compressed = this.imageData.getImageData(strip).getData();
            byte[] decompressed = this.decompress(compressed, this.compression, (int)bytesPerStrip, this.width, (int)rowsInThisStrip);
            this.interpretStrip(imageBuilder, decompressed, (int)pixelsPerStrip, this.height);
        }
    }

    @Override
    public BufferedImage readImageData(Rectangle subImage) throws ImageReadException, IOException {
        int strip0 = subImage.y / this.rowsPerStrip;
        int strip1 = (subImage.y + subImage.height - 1) / this.rowsPerStrip;
        int workingHeight = (strip1 - strip0 + 1) * this.rowsPerStrip;
        int y0 = strip0 * this.rowsPerStrip;
        int yLimit = subImage.y - y0 + subImage.height;
        ImageBuilder workingBuilder = new ImageBuilder(this.width, workingHeight, false);
        for (int strip = strip0; strip <= strip1; ++strip) {
            long rowsPerStripLong = 0xFFFFFFFFL & (long)this.rowsPerStrip;
            long rowsRemaining = (long)this.height - (long)strip * rowsPerStripLong;
            long rowsInThisStrip = Math.min(rowsRemaining, rowsPerStripLong);
            long bytesPerRow = (this.bitsPerPixel * this.width + 7) / 8;
            long bytesPerStrip = rowsInThisStrip * bytesPerRow;
            long pixelsPerStrip = rowsInThisStrip * (long)this.width;
            byte[] compressed = this.imageData.getImageData(strip).getData();
            byte[] decompressed = this.decompress(compressed, this.compression, (int)bytesPerStrip, this.width, (int)rowsInThisStrip);
            this.interpretStrip(workingBuilder, decompressed, (int)pixelsPerStrip, yLimit);
        }
        if (subImage.x == 0 && subImage.y == y0 && subImage.width == this.width && subImage.height == workingHeight) {
            return workingBuilder.getBufferedImage();
        }
        return workingBuilder.getSubimage(subImage.x, subImage.y - y0, subImage.width, subImage.height);
    }
}

