/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.graph.impl.AllCapabilities;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.graph.impl.TransactionHandlerBase;
import com.hp.hpl.jena.reasoner.Derivation;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;

public abstract class BaseInfGraph
extends GraphBase
implements InfGraph {
    protected Reasoner reasoner;
    protected FGraph fdata;
    protected boolean recordDerivations;
    private volatile boolean isPrepared = false;
    protected volatile int version = 0;

    @Override
    public PrefixMapping getPrefixMapping() {
        return this.getRawGraph().getPrefixMapping();
    }

    public BaseInfGraph(Graph data, Reasoner reasoner) {
        this.fdata = new FGraph(data);
        this.reasoner = reasoner;
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            return this.getReasoner().getGraphCapabilities();
        }
        return this.capabilities;
    }

    @Override
    @Deprecated
    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new InfBulkUpdateHandler(this);
        }
        return this.bulkHandler;
    }

    @Override
    public void remove(Node s, Node p, Node o) {
        this.getRawGraph().remove(s, p, o);
        this.discardState();
        this.rebind();
        this.getEventManager().notifyEvent(this, GraphEvents.remove(s, p, o));
    }

    @Override
    public void clear() {
        this.getRawGraph().clear();
        this.discardState();
        this.rebind();
        this.getEventManager().notifyEvent(this, GraphEvents.removeAll);
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return new InfTransactionHandler(this);
    }

    protected void discardState() {
    }

    @Override
    public Graph getRawGraph() {
        return this.fdata.getGraph();
    }

    @Override
    public Reasoner getReasoner() {
        return this.reasoner;
    }

    @Override
    public synchronized void rebind(Graph data) {
        this.fdata = new FGraph(data);
        this.isPrepared = false;
    }

    @Override
    public synchronized void rebind() {
        ++this.version;
        this.isPrepared = false;
    }

    @Override
    public void reset() {
        ++this.version;
    }

    @Override
    public synchronized void prepare() {
        this.isPrepared = true;
    }

    @Override
    public Graph getDeductionsGraph() {
        return null;
    }

    @Override
    public Node getGlobalProperty(Node property) {
        throw new ReasonerException("Global property not implemented: " + property);
    }

    @Override
    public boolean testGlobalProperty(Node property) {
        Object result;
        Node resultNode = this.getGlobalProperty(property);
        if (resultNode.isLiteral() && (result = resultNode.getLiteralValue()) instanceof Boolean) {
            return (Boolean)result;
        }
        throw new ReasonerException("Global property test returned non-boolean value\nTest was: " + property + "\nResult was: " + resultNode);
    }

    @Override
    public ValidityReport validate() {
        this.checkOpen();
        return new StandardValidityReport();
    }

    @Override
    public ExtendedIterator<Triple> find(Node subject, Node property, Node object, Graph param) {
        return this.cloneWithPremises(param).find(subject, property, object);
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        return this.graphBaseFind(m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject());
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(Node subject, Node property, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, property, object), this.fdata);
    }

    public abstract ExtendedIterator<Triple> findWithContinuation(TriplePattern var1, Finder var2);

    public ExtendedIterator<Triple> find(TriplePattern pattern) {
        this.checkOpen();
        return this.findWithContinuation(pattern, this.fdata);
    }

    @Override
    public void setDerivationLogging(boolean logOn) {
        this.recordDerivations = logOn;
    }

    @Override
    public Iterator<Derivation> getDerivation(Triple triple) {
        return null;
    }

    @Override
    public int graphBaseSize() {
        this.checkOpen();
        return this.fdata.getGraph().size();
    }

    @Override
    public boolean isEmpty() {
        return this.fdata.getGraph().isEmpty();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.fdata.getGraph().close();
            this.fdata = null;
            super.close();
        }
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public synchronized void performAdd(Triple t) {
        ++this.version;
        this.requirePrepared();
        this.fdata.getGraph().add(t);
    }

    @Override
    public void performDelete(Triple t) {
        ++this.version;
        this.requirePrepared();
        this.fdata.getGraph().delete(t);
    }

    public abstract Graph getSchemaGraph();

    public InfGraph cloneWithPremises(Graph premises) {
        MultiUnion union = new MultiUnion();
        Graph raw = this.getRawGraph();
        union.addGraph(raw);
        union.setBaseGraph(raw);
        union.addGraph(premises);
        Graph schema = this.getSchemaGraph();
        if (schema != null && schema instanceof BaseInfGraph) {
            Graph rschema;
            BaseInfGraph ischema = (BaseInfGraph)schema;
            Graph sschema = ischema.getSchemaGraph();
            if (sschema != null) {
                union.addGraph(sschema);
            }
            if ((rschema = ischema.getRawGraph()) != null) {
                union.addGraph(rschema);
            }
        }
        return this.getReasoner().bind(union);
    }

    public synchronized boolean isPrepared() {
        return this.isPrepared;
    }

    protected synchronized void setPreparedState(boolean state) {
        this.isPrepared = state;
    }

    protected synchronized void requirePrepared() {
        if (!this.isPrepared) {
            this.prepare();
        }
    }

    public static class InfTransactionHandler
    extends TransactionHandlerBase
    implements TransactionHandler {
        protected final BaseInfGraph base;

        public InfTransactionHandler(BaseInfGraph base) {
            this.base = base;
        }

        @Override
        public boolean transactionsSupported() {
            return this.getBaseHandler().transactionsSupported();
        }

        protected TransactionHandler getBaseHandler() {
            return this.base.getRawGraph().getTransactionHandler();
        }

        @Override
        public void begin() {
            this.getBaseHandler().begin();
        }

        @Override
        public void abort() {
            this.getBaseHandler().abort();
            this.base.rebind();
        }

        @Override
        public void commit() {
            this.getBaseHandler().commit();
        }
    }

    static class InfBulkUpdateHandler
    extends SimpleBulkUpdateHandler {
        public InfBulkUpdateHandler(BaseInfGraph graph) {
            super(graph);
        }

        @Override
        @Deprecated
        public void remove(Node s, Node p, Node o) {
            BaseInfGraph g = (BaseInfGraph)this.graph;
            g.getRawGraph().remove(s, p, o);
            g.discardState();
            g.rebind();
            this.manager.notifyEvent(this.graph, GraphEvents.remove(s, p, o));
        }

        @Override
        @Deprecated
        public void removeAll() {
            BaseInfGraph g = (BaseInfGraph)this.graph;
            g.getRawGraph().clear();
            g.discardState();
            g.rebind();
            g.getEventManager().notifyEvent(g, GraphEvents.removeAll);
        }
    }

    public static class InfFindSafeCapabilities
    extends InfCapabilities {
        @Override
        public boolean findContractSafe() {
            return true;
        }
    }

    public static class InfCapabilities
    extends AllCapabilities {
        @Override
        public boolean sizeAccurate() {
            return false;
        }

        @Override
        public boolean deleteAllowed(boolean every) {
            return !every;
        }

        @Override
        public boolean iteratorRemoveAllowed() {
            return false;
        }

        @Override
        public boolean findContractSafe() {
            return false;
        }
    }
}

