/*
 * Decompiled with CFR 0.152.
 */
package ptl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.mappaint.styleelement.LabelCompositionStrategy;
import org.openstreetmap.josm.gui.mappaint.styleelement.TextLabel;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public class PublicTransportLayer
extends Layer {
    private static final ImageProvider ICON = new ImageProvider("presets/misc", "route");
    private boolean doDrawArrows = true;
    private boolean doDrawRefLabels = true;

    public PublicTransportLayer() {
        super(I18n.tr((String)"Public transport routes", (Object[])new Object[0]));
    }

    public void paint(Graphics2D g, MapView mv, Bounds box) {
        if (mv == null || mv.getLayerManager().getEditLayer() == null || mv.getLayerManager().getEditLayer().data.selectionEmpty()) {
            return;
        }
        StyledMapRenderer renderer = new StyledMapRenderer(g, (NavigatableComponent)mv, false);
        Collection selectedRelations = mv.getLayerManager().getEditLayer().data.getSelectedRelations();
        MultiMap segmentRefs = new MultiMap();
        for (Relation relation : selectedRelations) {
            if (relation.isIncomplete() || relation.hasIncompleteMembers() || !relation.hasTag("type", "route") || !relation.hasTag("public_transport:version", "2")) continue;
            Way way = new Way();
            Node previousNode = null;
            for (RelationMember member : relation.getMembers()) {
                if (!OsmPrimitiveType.NODE.equals((Object)member.getType()) || !"stop".equals(member.getRole())) continue;
                way.addNode(member.getNode());
                if (previousNode != null) {
                    segmentRefs.put((Object)Pair.create((Object)previousNode, (Object)member.getNode()), (Object)relation.get("ref"));
                }
                previousNode = member.getNode();
            }
            Color color = Color.GREEN;
            try {
                color = ColorHelper.html2color((String)relation.get("colour"));
            }
            catch (RuntimeException ignore) {
                Main.trace((Throwable)ignore);
            }
            renderer.drawWay(way, color, new BasicStroke(1.0f), null, null, 0.0f, this.doDrawArrows, false, false, false);
        }
        if (this.doDrawRefLabels) {
            this.drawRefLabels(renderer, (MultiMap<Pair<Node, Node>, String>)segmentRefs);
        }
    }

    protected void drawRefLabels(StyledMapRenderer renderer, MultiMap<Pair<Node, Node>, String> segmentRefs) {
        for (Pair nodePair : segmentRefs.keySet()) {
            String label = Utils.join((String)I18n.tr((String)", ", (Object[])new Object[0]), new TreeSet(segmentRefs.get((Object)nodePair)));
            TextLabel text = new TextLabel((LabelCompositionStrategy)new LabelCompositionStrategy.StaticLabelCompositionStrategy(label), new Font("SansSerif", 0, 16), 0, 0, new Color(-2130706433, true), Float.valueOf(0.0f), null);
            Way way = new Way();
            way.addNode((Node)nodePair.a);
            way.addNode((Node)nodePair.b);
            renderer.drawTextOnPath(way, text);
        }
    }

    public Icon getIcon() {
        return ICON.setMaxSize(ImageProvider.ImageSizes.LAYER).get();
    }

    public String getToolTipText() {
        return "";
    }

    public void mergeFrom(Layer from) {
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Object getInfoComponent() {
        return null;
    }

    public Action[] getMenuEntries() {
        return new Action[]{new AbstractAction(I18n.tr((String)"Toggle direction arrows", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                PublicTransportLayer.this.doDrawArrows = !PublicTransportLayer.this.doDrawArrows;
                Main.map.repaint();
            }
        }, new AbstractAction(I18n.tr((String)"Toggle reference labels", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                PublicTransportLayer.this.doDrawRefLabels = !PublicTransportLayer.this.doDrawRefLabels;
                Main.map.repaint();
            }
        }};
    }

    public static class AddLayerAction
    extends JosmAction {
        public AddLayerAction() {
            super(I18n.tr((String)"Visualize public transport routes", (Object[])new Object[0]), ICON, I18n.tr((String)"Displays stops of selected public transport routes as graph", (Object[])new Object[0]), null, false, null, false);
        }

        public void actionPerformed(ActionEvent e) {
            Main.getLayerManager().addLayer((Layer)new PublicTransportLayer());
        }
    }
}

