/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;

public class GenericCommand
extends Command {
    private final DataSet dataSet;
    private final String description;
    private final Map<OsmPrimitive, BeforeAfter> beforeAfters = new HashMap<OsmPrimitive, BeforeAfter>();

    public GenericCommand(DataSet dataSet, String description) {
        this.dataSet = dataSet;
        this.description = description;
    }

    void add(OsmPrimitive p) {
        this.beforeAfters.put(p, new BeforeAfter(null, (AbstractPrimitive)p));
    }

    AbstractPrimitive backup(OsmPrimitive p) {
        BeforeAfter ba = this.beforeAfters.get(p);
        if (ba == null) {
            BeforeAfter newBa = new BeforeAfter(p.save(), (AbstractPrimitive)p.save());
            this.beforeAfters.put(p, newBa);
            return newBa.after;
        }
        return ba.after;
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        return this.description;
    }

    public boolean executeCommand() {
        for (Map.Entry<OsmPrimitive, BeforeAfter> e : this.beforeAfters.entrySet()) {
            if (e.getValue().before == null) {
                this.dataSet.addPrimitive(e.getValue().afterPrimitive());
                continue;
            }
            e.getKey().load(e.getValue().afterData());
        }
        return true;
    }

    public void undoCommand() {
        for (Map.Entry<OsmPrimitive, BeforeAfter> e : this.beforeAfters.entrySet()) {
            if (e.getValue().before == null) {
                this.dataSet.removePrimitive(e.getValue().afterPrimitive().getPrimitiveId());
                continue;
            }
            e.getKey().load(e.getValue().before);
        }
    }

    public PrimitiveData getOrig(OsmPrimitive osm) {
        return this.beforeAfters.get((Object)osm).before;
    }

    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return Collections.unmodifiableSet(this.beforeAfters.keySet());
    }

    private static final class BeforeAfter {
        final PrimitiveData before;
        final AbstractPrimitive after;

        BeforeAfter(PrimitiveData before, AbstractPrimitive after) {
            this.before = before;
            this.after = after;
        }

        public OsmPrimitive afterPrimitive() {
            return (OsmPrimitive)this.after;
        }

        public PrimitiveData afterData() {
            return (PrimitiveData)this.after;
        }
    }
}

