/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import reverter.ChangesetIdQuery;
import reverter.ChangesetReverter;
import reverter.RevertChangesetTask;

public class RevertChangesetAction
extends JosmAction {
    public RevertChangesetAction() {
        super(I18n.tr((String)"Revert changeset", (Object[])new Object[0]), "revert-changeset", I18n.tr((String)"Revert changeset", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tool:revert", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Revert changeset", (Object[])new Object[0])}), (int)84, (int)5009), true);
    }

    public void actionPerformed(ActionEvent arg0) {
        ChangesetIdQuery dlg = new ChangesetIdQuery();
        if (dlg.showDialog().getValue() != 1) {
            return;
        }
        Collection<Integer> changesetIds = dlg.getIdsInReverseOrder();
        ChangesetReverter.RevertType revertType = dlg.getRevertType();
        if (revertType == null) {
            return;
        }
        boolean newLayer = dlg.isNewLayerRequired();
        boolean autoConfirmDownload = newLayer || changesetIds.size() > 1;
        for (Integer changesetId : changesetIds) {
            Main.worker.submit((Runnable)((Object)new RevertChangesetTask(changesetId, revertType, autoConfirmDownload, newLayer)));
            newLayer = false;
        }
    }
}

