/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSorter;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;
import relcontext.actions.PublicTransportHelper;

public class ReconstructRouteAction
extends AbstractAction
implements ChosenRelationListener {
    private final ChosenRelation rel;
    private static final double maxSqrDistBetweenStopAndPlatform = 2000.0;

    public ReconstructRouteAction(ChosenRelation rel) {
        super(I18n.tr((String)"Reconstruct route", (Object[])new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"filter"));
        this.putValue("LongDescription", "Reconstruct route relation to scheme of public_transport");
        this.rel = rel;
        rel.addChosenRelationListener(this);
        this.setEnabled(this.isSuitableRelation(rel.get()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Relation r = this.rel.get();
        Relation recRel = new Relation(r);
        recRel.removeMembersFor((Collection)recRel.getMemberPrimitives());
        LinkedHashMap<OsmPrimitive, RelationMember> stopMembers = new LinkedHashMap<OsmPrimitive, RelationMember>();
        LinkedHashMap platformMembers = new LinkedHashMap();
        List<RelationMember> routeMembers = new ArrayList();
        ArrayList<RelationMember> wtfMembers = new ArrayList<RelationMember>();
        int mCount = r.getMembersCount();
        for (int i = 0; i < mCount; ++i) {
            RelationMember rm;
            RelationMember m = r.getMember(i);
            if (PublicTransportHelper.isMemberStop(m)) {
                rm = new RelationMember(m.hasRole() ? m.getRole() : "stop", m.getMember());
                stopMembers.put(rm.getMember(), rm);
                continue;
            }
            if (PublicTransportHelper.isMemberPlatform(m)) {
                rm = new RelationMember(m.hasRole() ? m.getRole() : "platform", m.getMember());
                String platformName = PublicTransportHelper.getNameViaStoparea(rm);
                if (platformName == null) {
                    platformName = "";
                }
                if (platformMembers.containsKey(platformName)) {
                    ((List)platformMembers.get(platformName)).add(rm);
                    continue;
                }
                ArrayList<RelationMember> nList = new ArrayList<RelationMember>();
                nList.add(rm);
                platformMembers.put(platformName, nList);
                continue;
            }
            if (PublicTransportHelper.isMemberRouteway(m)) {
                routeMembers.add(new RelationMember(m));
                continue;
            }
            wtfMembers.add(new RelationMember(m));
        }
        routeMembers = RelationSorter.sortMembersByConnectivity(routeMembers);
        Node lastNode = null;
        for (int rIndex = 0; rIndex < routeMembers.size(); ++rIndex) {
            Way w = (Way)((RelationMember)routeMembers.get(rIndex)).getMember();
            boolean dirForward = false;
            if (lastNode == null) {
                if (routeMembers.size() > 2) {
                    Way nextWay = (Way)((RelationMember)routeMembers.get(rIndex + 1)).getMember();
                    if (w.lastNode().equals((Object)nextWay.lastNode()) || w.lastNode().equals((Object)nextWay.firstNode())) {
                        dirForward = true;
                        lastNode = w.lastNode();
                    } else {
                        lastNode = w.firstNode();
                    }
                }
            } else if (lastNode.equals((Object)w.firstNode())) {
                dirForward = true;
                lastNode = w.lastNode();
            } else {
                lastNode = w.firstNode();
            }
            int wayNodeBeginIndex = dirForward ? 0 : w.getNodesCount() - 1;
            int wayNodeEndIndex = dirForward ? w.getNodesCount() - 1 : 0;
            int increment = dirForward ? 1 : -1;
            for (int nIndex = wayNodeBeginIndex; nIndex != wayNodeEndIndex; nIndex += increment) {
                boolean existsPlatform;
                Node refNode = w.getNode(nIndex);
                if (!PublicTransportHelper.isNodeStop((OsmPrimitive)refNode) || !stopMembers.containsKey(refNode)) continue;
                recRel.addMember((RelationMember)stopMembers.get(refNode));
                stopMembers.remove(refNode);
                String stopName = PublicTransportHelper.getNameViaStoparea((OsmPrimitive)refNode);
                if (stopName == null) {
                    stopName = "";
                }
                if (!(existsPlatform = platformMembers.containsKey(stopName))) {
                    stopName = "";
                }
                if (!existsPlatform && !platformMembers.containsKey(stopName)) continue;
                List lMember = (List)platformMembers.get(stopName);
                if (lMember.size() == 1) {
                    recRel.addMember((RelationMember)lMember.get(0));
                    lMember.remove(0);
                } else {
                    RelationMember candidat = this.getClosestPlatform(lMember, refNode);
                    if (candidat != null) {
                        recRel.addMember(candidat);
                        lMember.remove(candidat);
                    }
                }
                if (!lMember.isEmpty()) continue;
                platformMembers.remove(stopName);
            }
        }
        for (RelationMember stop : stopMembers.values()) {
            recRel.addMember(stop);
            String stopName = PublicTransportHelper.getNameViaStoparea(stop);
            boolean existsPlatform = platformMembers.containsKey(stopName);
            if (!existsPlatform) {
                stopName = "";
            }
            if (!existsPlatform && !platformMembers.containsKey(stopName)) continue;
            List lMember = (List)platformMembers.get(stopName);
            if (lMember.size() == 1) {
                recRel.addMember((RelationMember)lMember.get(0));
                lMember.remove(0);
            } else {
                RelationMember candidat = this.getClosestPlatform(lMember, stop.getNode());
                if (candidat != null) {
                    recRel.addMember(candidat);
                    lMember.remove(candidat);
                }
            }
            if (!lMember.isEmpty()) continue;
            platformMembers.remove(stopName);
        }
        for (List lPlatforms : platformMembers.values()) {
            for (RelationMember platform : lPlatforms) {
                recRel.addMember(platform);
            }
        }
        for (RelationMember route : routeMembers) {
            recRel.addMember(route);
        }
        for (RelationMember wtf : wtfMembers) {
            recRel.addMember(wtf);
        }
        ChangeCommand command = new ChangeCommand((OsmPrimitive)r, (OsmPrimitive)recRel);
        Main.main.undoRedo.add((Command)command);
    }

    private RelationMember getClosestPlatform(List<RelationMember> members, Node stop) {
        if (stop == null || members.isEmpty()) {
            return null;
        }
        double maxDist = 2000.0;
        RelationMember result = null;
        for (RelationMember member : members) {
            if (member.getType() == OsmPrimitiveType.NODE) {
                Node node = member.getNode();
                double sqrDist = stop.getEastNorth().distanceSq(node.getEastNorth());
                if (!(sqrDist < maxDist)) continue;
                maxDist = sqrDist;
                result = member;
                continue;
            }
            if (member.getType() != OsmPrimitiveType.WAY) continue;
            Way way = member.getWay();
            EastNorth closest = Geometry.closestPointToSegment((EastNorth)way.firstNode().getEastNorth(), (EastNorth)way.lastNode().getEastNorth(), (EastNorth)stop.getEastNorth());
            double sqrDist = stop.getEastNorth().distanceSq(closest);
            if (!(sqrDist < maxDist)) continue;
            maxDist = sqrDist;
            result = member;
        }
        return result;
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.setEnabled(this.isSuitableRelation(newRelation));
    }

    private boolean isSuitableRelation(Relation newRelation) {
        return newRelation != null && "route".equals(newRelation.get("type")) && newRelation.getMembersCount() != 0;
    }
}

