/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photoadjust;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.Action;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.photoadjust.PhotoAdjustMapMode;
import org.openstreetmap.josm.plugins.photoadjust.PhotoAdjustWorker;
import org.openstreetmap.josm.plugins.photoadjust.PhotoPropertyEditor;
import org.openstreetmap.josm.plugins.photoadjust.UntaggedGeoImageLayerAction;

public class PhotoAdjustPlugin
extends Plugin
implements MainLayerManager.ActiveLayerChangeListener {
    private GeoImageLayer imageLayer = null;
    private MouseAdapter mouseAdapter = null;
    private MouseMotionAdapter mouseMotionAdapter = null;
    public PhotoAdjustWorker worker = null;

    public PhotoAdjustPlugin(PluginInformation info) {
        super(info);
        GeoImageLayer.registerMenuAddition((Action)new UntaggedGeoImageLayerAction());
        new PhotoPropertyEditor();
        this.worker = new PhotoAdjustWorker();
        this.initAdapters();
    }

    private void initAdapters() {
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (PhotoAdjustPlugin.this.imageLayer != null) {
                    ArrayList<GeoImageLayer> layers = new ArrayList<GeoImageLayer>(1);
                    layers.add(PhotoAdjustPlugin.this.imageLayer);
                    PhotoAdjustPlugin.this.worker.doMousePressed(evt, layers);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (PhotoAdjustPlugin.this.imageLayer != null) {
                    PhotoAdjustPlugin.this.worker.doMouseReleased(evt);
                }
            }
        };
        this.mouseMotionAdapter = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                PhotoAdjustPlugin.this.worker.doMouseDragged(evt);
            }
        };
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            Main.getLayerManager().addAndFireActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
            PhotoAdjustMapMode adjustMode = new PhotoAdjustMapMode(newFrame, this.worker);
            adjustMode.installMapMode(newFrame);
        } else {
            Main.getLayerManager().removeActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        }
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        this.worker.reset();
        Layer oldLayer = e.getPreviousActiveLayer();
        Layer newLayer = Main.getLayerManager().getActiveLayer();
        if (oldLayer instanceof GeoImageLayer && newLayer instanceof GeoImageLayer) {
            this.imageLayer = (GeoImageLayer)newLayer;
        } else {
            if (oldLayer instanceof GeoImageLayer) {
                Main.map.mapView.removeMouseListener((MouseListener)this.mouseAdapter);
                Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this.mouseMotionAdapter);
                this.imageLayer = null;
            }
            if (newLayer instanceof GeoImageLayer) {
                this.imageLayer = (GeoImageLayer)newLayer;
                Main.map.mapView.addMouseListener((MouseListener)this.mouseAdapter);
                Main.map.mapView.addMouseMotionListener((MouseMotionListener)this.mouseMotionAdapter);
            }
        }
    }
}

