/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastrePlugin;
import cadastre_fr.DownloadWMSPlanImage;
import cadastre_fr.MenuActionNewLocation;
import cadastre_fr.RasterImageGeoreferencer;
import cadastre_fr.WMSLayer;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;

public class MenuActionGrabPlanImage
extends JosmAction
implements Runnable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = I18n.marktr((String)"Georeference an image");
    private DownloadWMSPlanImage downloadWMSPlanImage;
    private WMSLayer wmsLayer;
    private RasterImageGeoreferencer rasterImageGeoreferencer = new RasterImageGeoreferencer();

    public MenuActionGrabPlanImage() {
        super(I18n.tr((String)NAME, (Object[])new Object[0]), "cadastre_small", I18n.tr((String)"Grab non-georeferenced image", (Object[])new Object[0]), null, false, "cadastrefr/grabplanimage", true);
    }

    protected void updateEnabledState() {
        if (this.wmsLayer == null || Main.map == null || Main.map.mapView == null) {
            return;
        }
        if (!this.rasterImageGeoreferencer.isRunning()) {
            return;
        }
        if (Main.getLayerManager().containsLayer((Layer)this.wmsLayer)) {
            return;
        }
        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Georeferencing interrupted", (Object[])new Object[0]));
        this.rasterImageGeoreferencer.actionInterrupted();
    }

    public void actionPerformed(ActionEvent ae) {
        if (Main.map != null) {
            if (CadastrePlugin.isCadastreProjection()) {
                this.wmsLayer = new MenuActionNewLocation().addNewLayer(new ArrayList<WMSLayer>());
                if (this.wmsLayer == null) {
                    return;
                }
                this.downloadWMSPlanImage = new DownloadWMSPlanImage();
                this.downloadWMSPlanImage.download(this.wmsLayer);
                Main.worker.execute(this);
            } else {
                CadastrePlugin.askToChangeProjection();
            }
        }
    }

    @Override
    public void run() {
        boolean loadedFromCache = this.downloadWMSPlanImage.waitFinished();
        if (loadedFromCache) {
            Main.map.repaint();
        } else if (this.wmsLayer.getImages().size() == 0) {
            this.rasterImageGeoreferencer.actionInterrupted();
        } else {
            int reply = 2;
            if (this.wmsLayer.isAlreadyGeoreferenced()) {
                reply = JOptionPane.showConfirmDialog(null, I18n.tr((String)"This image contains georeference data.\nDo you want to use them ?", (Object[])new Object[0]), null, 0);
            }
            if (reply == 0) {
                this.rasterImageGeoreferencer.transformGeoreferencedImg();
            } else {
                this.rasterImageGeoreferencer.addListener();
                if (!Main.pref.getBoolean("cadastrewms.noImageCropping", false)) {
                    this.rasterImageGeoreferencer.startCropping(this.wmsLayer);
                } else {
                    this.rasterImageGeoreferencer.startGeoreferencing(this.wmsLayer);
                }
            }
        }
    }
}

