/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.nio.ByteOrder;
import java.util.Locale;

public class ByteOrderFactory {
    private static final Locale ComparisonLocale = Locale.ROOT;
    public static final String BIG_ENDIAN = "Big";
    public static final String LITTLE_ENDIAN = "Little";

    public static ByteOrder parseByteOrder(String value) {
        String valueUp = value.toUpperCase(ComparisonLocale);
        String bigEndianUp = BIG_ENDIAN.toUpperCase(ComparisonLocale);
        String littleEndianUp = LITTLE_ENDIAN.toUpperCase(ComparisonLocale);
        if (bigEndianUp.equals(valueUp) || ByteOrder.BIG_ENDIAN.toString().equals(valueUp)) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (littleEndianUp.equals(valueUp) || ByteOrder.LITTLE_ENDIAN.toString().equals(valueUp)) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        throw new IllegalArgumentException("Unsupported byte order setting: " + value + ", expeced one of " + ByteOrder.LITTLE_ENDIAN + ", " + LITTLE_ENDIAN + ", " + ByteOrder.BIG_ENDIAN + ", " + bigEndianUp);
    }
}

